/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.resolver;

import co.elastic.logstash.filters.elasticintegration.resolver.CacheReloader;
import co.elastic.logstash.filters.elasticintegration.util.PluginContext;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.ScheduledExecutorService;

public class CacheReloadService
extends AbstractScheduledService {
    final CacheReloader reloader;
    final ScheduledExecutorService executor;
    final AbstractScheduledService.Scheduler scheduler;

    public static CacheReloadService newManaged(PluginContext pluginContext, CacheReloader reloader, AbstractScheduledService.Scheduler scheduler) {
        String threadPurpose = String.format("cache-reloader(%s)", reloader.type());
        final ScheduledExecutorService executor = pluginContext.newSingleThreadScheduledExecutor(threadPurpose);
        CacheReloadService cacheReloadService = new CacheReloadService(reloader, executor, scheduler);
        cacheReloadService.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                executor.shutdown();
            }

            public void failed(Service.State from, Throwable failure) {
                executor.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return cacheReloadService;
    }

    private CacheReloadService(CacheReloader reloader, ScheduledExecutorService executor, AbstractScheduledService.Scheduler scheduler) {
        this.reloader = reloader;
        this.executor = executor;
        this.scheduler = scheduler;
    }

    protected void runOneIteration() throws Exception {
        this.reloader.reloadOnce();
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return this.scheduler;
    }

    protected ScheduledExecutorService executor() {
        return this.executor;
    }
}

