/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Event;
import co.elastic.logstash.filters.elasticintegration.EventToIndexNameResolver;
import co.elastic.logstash.filters.elasticintegration.util.EventUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatastreamEventToIndexNameResolver
implements EventToIndexNameResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATASTREAM_NAMESPACE_FIELD_REFERENCE = "[data_stream][namespace]";
    private static final String DATASTREAM_TYPE_FIELD_REFERENCE = "[data_stream][type]";
    private static final String DATASTREAM_DATASET_FIELD_REFERENCE = "[data_stream][dataset]";

    @Override
    public Optional<String> resolve(Event event, Consumer<Exception> exceptionHandler) {
        String namespace = EventUtil.safeExtractString(event, DATASTREAM_NAMESPACE_FIELD_REFERENCE);
        if (Objects.isNull(namespace)) {
            LOGGER.trace(() -> String.format("datastream not resolved from event: `%s` had no value", DATASTREAM_NAMESPACE_FIELD_REFERENCE));
            return Optional.empty();
        }
        String type = EventUtil.safeExtractString(event, DATASTREAM_TYPE_FIELD_REFERENCE);
        if (Objects.isNull(type)) {
            LOGGER.trace(() -> String.format("datastream not resolved from event: `%s` had no value", DATASTREAM_TYPE_FIELD_REFERENCE));
            return Optional.empty();
        }
        String dataset = EventUtil.safeExtractString(event, DATASTREAM_DATASET_FIELD_REFERENCE);
        if (Objects.isNull(dataset)) {
            LOGGER.trace(() -> String.format("datastream not resolved from event: `%s` had no value", DATASTREAM_DATASET_FIELD_REFERENCE));
            return Optional.empty();
        }
        String composedDatastream = String.format("%s-%s-%s", type, dataset, namespace);
        LOGGER.trace(() -> String.format("datastream resolved from event: `%s`", composedDatastream));
        return Optional.of(composedDatastream);
    }
}

