/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnalyticsStatistics
implements JsonpSerializable {
    private final long boxplotUsage;
    private final long cumulativeCardinalityUsage;
    private final long stringStatsUsage;
    private final long topMetricsUsage;
    private final long tTestUsage;
    private final long movingPercentilesUsage;
    private final long normalizeUsage;
    private final long rateUsage;
    @Nullable
    private final Long multiTermsUsage;
    public static final JsonpDeserializer<AnalyticsStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyticsStatistics::setupAnalyticsStatisticsDeserializer);

    private AnalyticsStatistics(Builder builder) {
        this.boxplotUsage = ApiTypeHelper.requireNonNull(builder.boxplotUsage, (Object)this, "boxplotUsage", 0L);
        this.cumulativeCardinalityUsage = ApiTypeHelper.requireNonNull(builder.cumulativeCardinalityUsage, (Object)this, "cumulativeCardinalityUsage", 0L);
        this.stringStatsUsage = ApiTypeHelper.requireNonNull(builder.stringStatsUsage, (Object)this, "stringStatsUsage", 0L);
        this.topMetricsUsage = ApiTypeHelper.requireNonNull(builder.topMetricsUsage, (Object)this, "topMetricsUsage", 0L);
        this.tTestUsage = ApiTypeHelper.requireNonNull(builder.tTestUsage, (Object)this, "tTestUsage", 0L);
        this.movingPercentilesUsage = ApiTypeHelper.requireNonNull(builder.movingPercentilesUsage, (Object)this, "movingPercentilesUsage", 0L);
        this.normalizeUsage = ApiTypeHelper.requireNonNull(builder.normalizeUsage, (Object)this, "normalizeUsage", 0L);
        this.rateUsage = ApiTypeHelper.requireNonNull(builder.rateUsage, (Object)this, "rateUsage", 0L);
        this.multiTermsUsage = builder.multiTermsUsage;
    }

    public static AnalyticsStatistics of(Function<Builder, ObjectBuilder<AnalyticsStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long boxplotUsage() {
        return this.boxplotUsage;
    }

    public final long cumulativeCardinalityUsage() {
        return this.cumulativeCardinalityUsage;
    }

    public final long stringStatsUsage() {
        return this.stringStatsUsage;
    }

    public final long topMetricsUsage() {
        return this.topMetricsUsage;
    }

    public final long tTestUsage() {
        return this.tTestUsage;
    }

    public final long movingPercentilesUsage() {
        return this.movingPercentilesUsage;
    }

    public final long normalizeUsage() {
        return this.normalizeUsage;
    }

    public final long rateUsage() {
        return this.rateUsage;
    }

    @Nullable
    public final Long multiTermsUsage() {
        return this.multiTermsUsage;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("boxplot_usage");
        generator.write(this.boxplotUsage);
        generator.writeKey("cumulative_cardinality_usage");
        generator.write(this.cumulativeCardinalityUsage);
        generator.writeKey("string_stats_usage");
        generator.write(this.stringStatsUsage);
        generator.writeKey("top_metrics_usage");
        generator.write(this.topMetricsUsage);
        generator.writeKey("t_test_usage");
        generator.write(this.tTestUsage);
        generator.writeKey("moving_percentiles_usage");
        generator.write(this.movingPercentilesUsage);
        generator.writeKey("normalize_usage");
        generator.write(this.normalizeUsage);
        generator.writeKey("rate_usage");
        generator.write(this.rateUsage);
        if (this.multiTermsUsage != null) {
            generator.writeKey("multi_terms_usage");
            generator.write(this.multiTermsUsage);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAnalyticsStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boxplotUsage, JsonpDeserializer.longDeserializer(), "boxplot_usage");
        op.add(Builder::cumulativeCardinalityUsage, JsonpDeserializer.longDeserializer(), "cumulative_cardinality_usage");
        op.add(Builder::stringStatsUsage, JsonpDeserializer.longDeserializer(), "string_stats_usage");
        op.add(Builder::topMetricsUsage, JsonpDeserializer.longDeserializer(), "top_metrics_usage");
        op.add(Builder::tTestUsage, JsonpDeserializer.longDeserializer(), "t_test_usage");
        op.add(Builder::movingPercentilesUsage, JsonpDeserializer.longDeserializer(), "moving_percentiles_usage");
        op.add(Builder::normalizeUsage, JsonpDeserializer.longDeserializer(), "normalize_usage");
        op.add(Builder::rateUsage, JsonpDeserializer.longDeserializer(), "rate_usage");
        op.add(Builder::multiTermsUsage, JsonpDeserializer.longDeserializer(), "multi_terms_usage");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnalyticsStatistics> {
        private Long boxplotUsage;
        private Long cumulativeCardinalityUsage;
        private Long stringStatsUsage;
        private Long topMetricsUsage;
        private Long tTestUsage;
        private Long movingPercentilesUsage;
        private Long normalizeUsage;
        private Long rateUsage;
        @Nullable
        private Long multiTermsUsage;

        public final Builder boxplotUsage(long value) {
            this.boxplotUsage = value;
            return this;
        }

        public final Builder cumulativeCardinalityUsage(long value) {
            this.cumulativeCardinalityUsage = value;
            return this;
        }

        public final Builder stringStatsUsage(long value) {
            this.stringStatsUsage = value;
            return this;
        }

        public final Builder topMetricsUsage(long value) {
            this.topMetricsUsage = value;
            return this;
        }

        public final Builder tTestUsage(long value) {
            this.tTestUsage = value;
            return this;
        }

        public final Builder movingPercentilesUsage(long value) {
            this.movingPercentilesUsage = value;
            return this;
        }

        public final Builder normalizeUsage(long value) {
            this.normalizeUsage = value;
            return this;
        }

        public final Builder rateUsage(long value) {
            this.rateUsage = value;
            return this;
        }

        public final Builder multiTermsUsage(@Nullable Long value) {
            this.multiTermsUsage = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnalyticsStatistics build() {
            this._checkSingleUse();
            return new AnalyticsStatistics(this);
        }
    }
}

