/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Cpu;
import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Process
implements JsonpSerializable {
    @Nullable
    private final Cpu cpu;
    @Nullable
    private final MemoryStats mem;
    @Nullable
    private final Integer openFileDescriptors;
    @Nullable
    private final Integer maxFileDescriptors;
    @Nullable
    private final Long timestamp;
    public static final JsonpDeserializer<Process> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Process::setupProcessDeserializer);

    private Process(Builder builder) {
        this.cpu = builder.cpu;
        this.mem = builder.mem;
        this.openFileDescriptors = builder.openFileDescriptors;
        this.maxFileDescriptors = builder.maxFileDescriptors;
        this.timestamp = builder.timestamp;
    }

    public static Process of(Function<Builder, ObjectBuilder<Process>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Cpu cpu() {
        return this.cpu;
    }

    @Nullable
    public final MemoryStats mem() {
        return this.mem;
    }

    @Nullable
    public final Integer openFileDescriptors() {
        return this.openFileDescriptors;
    }

    @Nullable
    public final Integer maxFileDescriptors() {
        return this.maxFileDescriptors;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cpu != null) {
            generator.writeKey("cpu");
            this.cpu.serialize(generator, mapper);
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.openFileDescriptors != null) {
            generator.writeKey("open_file_descriptors");
            generator.write(this.openFileDescriptors);
        }
        if (this.maxFileDescriptors != null) {
            generator.writeKey("max_file_descriptors");
            generator.write(this.maxFileDescriptors);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupProcessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, Cpu._DESERIALIZER, "cpu");
        op.add(Builder::mem, MemoryStats._DESERIALIZER, "mem");
        op.add(Builder::openFileDescriptors, JsonpDeserializer.integerDeserializer(), "open_file_descriptors");
        op.add(Builder::maxFileDescriptors, JsonpDeserializer.integerDeserializer(), "max_file_descriptors");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Process> {
        @Nullable
        private Cpu cpu;
        @Nullable
        private MemoryStats mem;
        @Nullable
        private Integer openFileDescriptors;
        @Nullable
        private Integer maxFileDescriptors;
        @Nullable
        private Long timestamp;

        public final Builder cpu(@Nullable Cpu value) {
            this.cpu = value;
            return this;
        }

        public final Builder cpu(Function<Cpu.Builder, ObjectBuilder<Cpu>> fn) {
            return this.cpu(fn.apply(new Cpu.Builder()).build());
        }

        public final Builder mem(@Nullable MemoryStats value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.mem(fn.apply(new MemoryStats.Builder()).build());
        }

        public final Builder openFileDescriptors(@Nullable Integer value) {
            this.openFileDescriptors = value;
            return this;
        }

        public final Builder maxFileDescriptors(@Nullable Integer value) {
            this.maxFileDescriptors = value;
            return this;
        }

        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Process build() {
            this._checkSingleUse();
            return new Process(this);
        }
    }
}

