/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.DataPathStats;
import co.elastic.clients.elasticsearch.nodes.FileSystemTotal;
import co.elastic.clients.elasticsearch.nodes.IoStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FileSystem
implements JsonpSerializable {
    private final List<DataPathStats> data;
    @Nullable
    private final Long timestamp;
    @Nullable
    private final FileSystemTotal total;
    @Nullable
    private final IoStats ioStats;
    public static final JsonpDeserializer<FileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSystem::setupFileSystemDeserializer);

    private FileSystem(Builder builder) {
        this.data = ApiTypeHelper.unmodifiable(builder.data);
        this.timestamp = builder.timestamp;
        this.total = builder.total;
        this.ioStats = builder.ioStats;
    }

    public static FileSystem of(Function<Builder, ObjectBuilder<FileSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DataPathStats> data() {
        return this.data;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final FileSystemTotal total() {
        return this.total;
    }

    @Nullable
    public final IoStats ioStats() {
        return this.ioStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.data)) {
            generator.writeKey("data");
            generator.writeStartArray();
            for (DataPathStats item0 : this.data) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp);
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
        if (this.ioStats != null) {
            generator.writeKey("io_stats");
            this.ioStats.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFileSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(DataPathStats._DESERIALIZER), "data");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::total, FileSystemTotal._DESERIALIZER, "total");
        op.add(Builder::ioStats, IoStats._DESERIALIZER, "io_stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FileSystem> {
        @Nullable
        private List<DataPathStats> data;
        @Nullable
        private Long timestamp;
        @Nullable
        private FileSystemTotal total;
        @Nullable
        private IoStats ioStats;

        public final Builder data(List<DataPathStats> list) {
            this.data = Builder._listAddAll(this.data, list);
            return this;
        }

        public final Builder data(DataPathStats value, DataPathStats ... values) {
            this.data = Builder._listAdd(this.data, value, values);
            return this;
        }

        public final Builder data(Function<DataPathStats.Builder, ObjectBuilder<DataPathStats>> fn) {
            return this.data(fn.apply(new DataPathStats.Builder()).build(), new DataPathStats[0]);
        }

        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder total(@Nullable FileSystemTotal value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<FileSystemTotal.Builder, ObjectBuilder<FileSystemTotal>> fn) {
            return this.total(fn.apply(new FileSystemTotal.Builder()).build());
        }

        public final Builder ioStats(@Nullable IoStats value) {
            this.ioStats = value;
            return this;
        }

        public final Builder ioStats(Function<IoStats.Builder, ObjectBuilder<IoStats>> fn) {
            return this.ioStats(fn.apply(new IoStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FileSystem build() {
            this._checkSingleUse();
            return new FileSystem(this);
        }
    }
}

