/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class SparseEmbeddingResult
implements JsonpSerializable {
    private final Map<String, Float> embedding;
    public static final JsonpDeserializer<SparseEmbeddingResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SparseEmbeddingResult::setupSparseEmbeddingResultDeserializer);

    private SparseEmbeddingResult(Builder builder) {
        this.embedding = ApiTypeHelper.unmodifiableRequired(builder.embedding, (Object)this, "embedding");
    }

    public static SparseEmbeddingResult of(Function<Builder, ObjectBuilder<SparseEmbeddingResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Float> embedding() {
        return this.embedding;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.embedding)) {
            generator.writeKey("embedding");
            generator.writeStartObject();
            for (Map.Entry<String, Float> item0 : this.embedding.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().floatValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSparseEmbeddingResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::embedding, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.floatDeserializer()), "embedding");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SparseEmbeddingResult> {
        private Map<String, Float> embedding;

        public final Builder embedding(Map<String, Float> map) {
            this.embedding = Builder._mapPutAll(this.embedding, map);
            return this;
        }

        public final Builder embedding(String key, Float value) {
            this.embedding = Builder._mapPut(this.embedding, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SparseEmbeddingResult build() {
            this._checkSingleUse();
            return new SparseEmbeddingResult(this);
        }
    }
}

