/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardsCapacityIndicatorTierDetail
implements JsonpSerializable {
    private final int maxShardsInCluster;
    @Nullable
    private final Integer currentUsedShards;
    public static final JsonpDeserializer<ShardsCapacityIndicatorTierDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsCapacityIndicatorTierDetail::setupShardsCapacityIndicatorTierDetailDeserializer);

    private ShardsCapacityIndicatorTierDetail(Builder builder) {
        this.maxShardsInCluster = ApiTypeHelper.requireNonNull(builder.maxShardsInCluster, (Object)this, "maxShardsInCluster", 0);
        this.currentUsedShards = builder.currentUsedShards;
    }

    public static ShardsCapacityIndicatorTierDetail of(Function<Builder, ObjectBuilder<ShardsCapacityIndicatorTierDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int maxShardsInCluster() {
        return this.maxShardsInCluster;
    }

    @Nullable
    public final Integer currentUsedShards() {
        return this.currentUsedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_shards_in_cluster");
        generator.write(this.maxShardsInCluster);
        if (this.currentUsedShards != null) {
            generator.writeKey("current_used_shards");
            generator.write(this.currentUsedShards);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardsCapacityIndicatorTierDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxShardsInCluster, JsonpDeserializer.integerDeserializer(), "max_shards_in_cluster");
        op.add(Builder::currentUsedShards, JsonpDeserializer.integerDeserializer(), "current_used_shards");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardsCapacityIndicatorTierDetail> {
        private Integer maxShardsInCluster;
        @Nullable
        private Integer currentUsedShards;

        public final Builder maxShardsInCluster(int value) {
            this.maxShardsInCluster = value;
            return this;
        }

        public final Builder currentUsedShards(@Nullable Integer value) {
            this.currentUsedShards = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardsCapacityIndicatorTierDetail build() {
            this._checkSingleUse();
            return new ShardsCapacityIndicatorTierDetail(this);
        }
    }
}

