/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.follow_info;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FollowerIndexParameters
implements JsonpSerializable {
    @Nullable
    private final Long maxOutstandingReadRequests;
    @Nullable
    private final Integer maxOutstandingWriteRequests;
    @Nullable
    private final Integer maxReadRequestOperationCount;
    @Nullable
    private final String maxReadRequestSize;
    @Nullable
    private final Time maxRetryDelay;
    @Nullable
    private final Integer maxWriteBufferCount;
    @Nullable
    private final String maxWriteBufferSize;
    @Nullable
    private final Integer maxWriteRequestOperationCount;
    @Nullable
    private final String maxWriteRequestSize;
    @Nullable
    private final Time readPollTimeout;
    public static final JsonpDeserializer<FollowerIndexParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowerIndexParameters::setupFollowerIndexParametersDeserializer);

    private FollowerIndexParameters(Builder builder) {
        this.maxOutstandingReadRequests = builder.maxOutstandingReadRequests;
        this.maxOutstandingWriteRequests = builder.maxOutstandingWriteRequests;
        this.maxReadRequestOperationCount = builder.maxReadRequestOperationCount;
        this.maxReadRequestSize = builder.maxReadRequestSize;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxWriteBufferCount = builder.maxWriteBufferCount;
        this.maxWriteBufferSize = builder.maxWriteBufferSize;
        this.maxWriteRequestOperationCount = builder.maxWriteRequestOperationCount;
        this.maxWriteRequestSize = builder.maxWriteRequestSize;
        this.readPollTimeout = builder.readPollTimeout;
    }

    public static FollowerIndexParameters of(Function<Builder, ObjectBuilder<FollowerIndexParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Nullable
    public final Integer maxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    @Nullable
    public final Integer maxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    @Nullable
    public final String maxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    @Nullable
    public final Time maxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Nullable
    public final Integer maxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    @Nullable
    public final String maxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    @Nullable
    public final Integer maxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    @Nullable
    public final String maxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    @Nullable
    public final Time readPollTimeout() {
        return this.readPollTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxOutstandingReadRequests != null) {
            generator.writeKey("max_outstanding_read_requests");
            generator.write(this.maxOutstandingReadRequests);
        }
        if (this.maxOutstandingWriteRequests != null) {
            generator.writeKey("max_outstanding_write_requests");
            generator.write(this.maxOutstandingWriteRequests);
        }
        if (this.maxReadRequestOperationCount != null) {
            generator.writeKey("max_read_request_operation_count");
            generator.write(this.maxReadRequestOperationCount);
        }
        if (this.maxReadRequestSize != null) {
            generator.writeKey("max_read_request_size");
            generator.write(this.maxReadRequestSize);
        }
        if (this.maxRetryDelay != null) {
            generator.writeKey("max_retry_delay");
            this.maxRetryDelay.serialize(generator, mapper);
        }
        if (this.maxWriteBufferCount != null) {
            generator.writeKey("max_write_buffer_count");
            generator.write(this.maxWriteBufferCount);
        }
        if (this.maxWriteBufferSize != null) {
            generator.writeKey("max_write_buffer_size");
            generator.write(this.maxWriteBufferSize);
        }
        if (this.maxWriteRequestOperationCount != null) {
            generator.writeKey("max_write_request_operation_count");
            generator.write(this.maxWriteRequestOperationCount);
        }
        if (this.maxWriteRequestSize != null) {
            generator.writeKey("max_write_request_size");
            generator.write(this.maxWriteRequestSize);
        }
        if (this.readPollTimeout != null) {
            generator.writeKey("read_poll_timeout");
            this.readPollTimeout.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFollowerIndexParametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.longDeserializer(), "max_outstanding_read_requests");
        op.add(Builder::maxOutstandingWriteRequests, JsonpDeserializer.integerDeserializer(), "max_outstanding_write_requests");
        op.add(Builder::maxReadRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_read_request_operation_count");
        op.add(Builder::maxReadRequestSize, JsonpDeserializer.stringDeserializer(), "max_read_request_size");
        op.add(Builder::maxRetryDelay, Time._DESERIALIZER, "max_retry_delay");
        op.add(Builder::maxWriteBufferCount, JsonpDeserializer.integerDeserializer(), "max_write_buffer_count");
        op.add(Builder::maxWriteBufferSize, JsonpDeserializer.stringDeserializer(), "max_write_buffer_size");
        op.add(Builder::maxWriteRequestOperationCount, JsonpDeserializer.integerDeserializer(), "max_write_request_operation_count");
        op.add(Builder::maxWriteRequestSize, JsonpDeserializer.stringDeserializer(), "max_write_request_size");
        op.add(Builder::readPollTimeout, Time._DESERIALIZER, "read_poll_timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FollowerIndexParameters> {
        @Nullable
        private Long maxOutstandingReadRequests;
        @Nullable
        private Integer maxOutstandingWriteRequests;
        @Nullable
        private Integer maxReadRequestOperationCount;
        @Nullable
        private String maxReadRequestSize;
        @Nullable
        private Time maxRetryDelay;
        @Nullable
        private Integer maxWriteBufferCount;
        @Nullable
        private String maxWriteBufferSize;
        @Nullable
        private Integer maxWriteRequestOperationCount;
        @Nullable
        private String maxWriteRequestSize;
        @Nullable
        private Time readPollTimeout;

        public final Builder maxOutstandingReadRequests(@Nullable Long value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        public final Builder maxOutstandingWriteRequests(@Nullable Integer value) {
            this.maxOutstandingWriteRequests = value;
            return this;
        }

        public final Builder maxReadRequestOperationCount(@Nullable Integer value) {
            this.maxReadRequestOperationCount = value;
            return this;
        }

        public final Builder maxReadRequestSize(@Nullable String value) {
            this.maxReadRequestSize = value;
            return this;
        }

        public final Builder maxRetryDelay(@Nullable Time value) {
            this.maxRetryDelay = value;
            return this;
        }

        public final Builder maxRetryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxRetryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxWriteBufferCount(@Nullable Integer value) {
            this.maxWriteBufferCount = value;
            return this;
        }

        public final Builder maxWriteBufferSize(@Nullable String value) {
            this.maxWriteBufferSize = value;
            return this;
        }

        public final Builder maxWriteRequestOperationCount(@Nullable Integer value) {
            this.maxWriteRequestOperationCount = value;
            return this;
        }

        public final Builder maxWriteRequestSize(@Nullable String value) {
            this.maxWriteRequestSize = value;
            return this;
        }

        public final Builder readPollTimeout(@Nullable Time value) {
            this.readPollTimeout = value;
            return this;
        }

        public final Builder readPollTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.readPollTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FollowerIndexParameters build() {
            this._checkSingleUse();
            return new FollowerIndexParameters(this);
        }
    }
}

