/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DynamicMapping;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.SyntheticSourceKeepEnum;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class PropertyBase
implements JsonpSerializable {
    private final Map<String, String> meta;
    private final Map<String, Property> properties;
    @Nullable
    private final Integer ignoreAbove;
    @Nullable
    private final DynamicMapping dynamic;
    private final Map<String, Property> fields;
    @Nullable
    private final SyntheticSourceKeepEnum syntheticSourceKeep;

    protected PropertyBase(AbstractBuilder<?> builder) {
        this.meta = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).meta);
        this.properties = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).properties);
        this.ignoreAbove = ((AbstractBuilder)builder).ignoreAbove;
        this.dynamic = ((AbstractBuilder)builder).dynamic;
        this.fields = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.syntheticSourceKeep = ((AbstractBuilder)builder).syntheticSourceKeep;
    }

    public final Map<String, String> meta() {
        return this.meta;
    }

    public final Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public final Integer ignoreAbove() {
        return this.ignoreAbove;
    }

    @Nullable
    public final DynamicMapping dynamic() {
        return this.dynamic;
    }

    public final Map<String, Property> fields() {
        return this.fields;
    }

    @Nullable
    public final SyntheticSourceKeepEnum syntheticSourceKeep() {
        return this.syntheticSourceKeep;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreAbove != null) {
            generator.writeKey("ignore_above");
            generator.write(this.ignoreAbove);
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            this.dynamic.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.syntheticSourceKeep != null) {
            generator.writeKey("synthetic_source_keep");
            this.syntheticSourceKeep.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta");
        op.add(AbstractBuilder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties");
        op.add(AbstractBuilder::ignoreAbove, JsonpDeserializer.integerDeserializer(), "ignore_above");
        op.add(AbstractBuilder::dynamic, DynamicMapping._DESERIALIZER, "dynamic");
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "fields");
        op.add(AbstractBuilder::syntheticSourceKeep, SyntheticSourceKeepEnum._DESERIALIZER, "synthetic_source_keep");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Map<String, String> meta;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private Integer ignoreAbove;
        @Nullable
        private DynamicMapping dynamic;
        @Nullable
        private Map<String, Property> fields;
        @Nullable
        private SyntheticSourceKeepEnum syntheticSourceKeep;

        public final BuilderT meta(Map<String, String> map) {
            this.meta = AbstractBuilder._mapPutAll(this.meta, map);
            return (BuilderT)this.self();
        }

        public final BuilderT meta(String key, String value) {
            this.meta = AbstractBuilder._mapPut(this.meta, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT properties(Map<String, Property> map) {
            this.properties = AbstractBuilder._mapPutAll(this.properties, map);
            return (BuilderT)this.self();
        }

        public final BuilderT properties(String key, Property value) {
            this.properties = AbstractBuilder._mapPut(this.properties, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(key, fn.apply(new Property.Builder()).build());
        }

        public final BuilderT ignoreAbove(@Nullable Integer value) {
            this.ignoreAbove = value;
            return (BuilderT)this.self();
        }

        public final BuilderT dynamic(@Nullable DynamicMapping value) {
            this.dynamic = value;
            return (BuilderT)this.self();
        }

        public final BuilderT fields(Map<String, Property> map) {
            this.fields = AbstractBuilder._mapPutAll(this.fields, map);
            return (BuilderT)this.self();
        }

        public final BuilderT fields(String key, Property value) {
            this.fields = AbstractBuilder._mapPut(this.fields, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT fields(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.fields(key, fn.apply(new Property.Builder()).build());
        }

        public final BuilderT syntheticSourceKeep(@Nullable SyntheticSourceKeepEnum value) {
            this.syntheticSourceKeep = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

