/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.TDigestExecutionHint;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TDigest
implements JsonpSerializable {
    @Nullable
    private final Integer compression;
    @Nullable
    private final TDigestExecutionHint executionHint;
    public static final JsonpDeserializer<TDigest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TDigest::setupTDigestDeserializer);

    private TDigest(Builder builder) {
        this.compression = builder.compression;
        this.executionHint = builder.executionHint;
    }

    public static TDigest of(Function<Builder, ObjectBuilder<TDigest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer compression() {
        return this.compression;
    }

    @Nullable
    public final TDigestExecutionHint executionHint() {
        return this.executionHint;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression);
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTDigestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::compression, JsonpDeserializer.integerDeserializer(), "compression");
        op.add(Builder::executionHint, TDigestExecutionHint._DESERIALIZER, "execution_hint");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TDigest> {
        @Nullable
        private Integer compression;
        @Nullable
        private TDigestExecutionHint executionHint;

        public final Builder compression(@Nullable Integer value) {
            this.compression = value;
            return this;
        }

        public final Builder executionHint(@Nullable TDigestExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TDigest build() {
            this._checkSingleUse();
            return new TDigest(this);
        }
    }
}

