/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.schema.id;

import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdDeserializer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;

public class ConfigSchemaIdDeserializer
implements SchemaIdDeserializer {
    public static final String USE_SCHEMA_ID = "use.schema.id";
    public static final String USE_SCHEMA_GUID = "use.schema.guid";
    private Integer id = null;
    private UUID guid = null;

    @Override
    public void configure(Map<String, ?> configs) {
        Object guidConfig;
        Object idConfig = configs.get(USE_SCHEMA_ID);
        if (idConfig != null) {
            try {
                this.id = Integer.parseInt(idConfig.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse " + String.valueOf(idConfig));
            }
        }
        if ((guidConfig = configs.get(USE_SCHEMA_GUID)) != null) {
            this.guid = UUID.fromString(guidConfig.toString());
        }
    }

    @Override
    public ByteBuffer deserialize(String topic, boolean isKey, Headers headers, byte[] payload, SchemaId schemaId) throws SerializationException {
        if (this.id != null) {
            schemaId.setId(this.id);
        }
        if (this.guid != null) {
            schemaId.setGuid(this.guid);
        }
        return ByteBuffer.wrap(payload);
    }
}

