/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.util.ArraySupport;
import org.jruby.util.unsafe.UnsafeHolder;

public class AtomicVariableTable {
    public static void setVariableAtomic(RubyBasicObject self2, RubyClass realClass, boolean fullFence, int index2, Object value2) {
        Object[] currentTable;
        int currentStamp;
        while (((currentStamp = self2.varTableStamp) & 1) != 0 || ((currentTable = (Object[])UnsafeHolder.U.getObjectVolatile(self2, RubyBasicObject.VAR_TABLE_OFFSET)) == null || index2 >= currentTable.length ? !AtomicVariableTable.createTableAtomic(self2, currentStamp, realClass, currentTable, index2, value2) : !AtomicVariableTable.updateTableAtomic(self2, currentStamp, fullFence, currentTable, index2, value2))) {
        }
    }

    private static boolean createTableAtomic(RubyBasicObject self2, int currentStamp, RubyClass realClass, Object[] currentTable, int index2, Object value2) {
        if (!UnsafeHolder.U.compareAndSwapInt(self2, RubyBasicObject.STAMP_OFFSET, currentStamp++, currentStamp)) {
            return false;
        }
        Object[] newTable = new Object[realClass.getVariableTableSizeWithExtras()];
        if (currentTable != null) {
            ArraySupport.copy(currentTable, 0, newTable, 0, currentTable.length);
        } else if (self2 instanceof JavaProxy) {
            ((JavaProxy)self2).checkVariablesOnProxy();
        }
        newTable[index2] = value2;
        UnsafeHolder.U.putOrderedObject(self2, RubyBasicObject.VAR_TABLE_OFFSET, newTable);
        self2.varTableStamp = currentStamp + 1;
        return true;
    }

    private static boolean updateTableAtomic(RubyBasicObject self2, int currentStamp, boolean fullFence, Object[] currentTable, int index2, Object value2) {
        currentTable[index2] = value2;
        if (fullFence) {
            UnsafeHolder.U.fullFence();
        }
        return self2.varTableStamp == currentStamp;
    }
}

