/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.shared.common.error.StandardException;

class UniqueIndexSortObserver
extends BasicSortObserver {
    private final boolean deferrable;
    private final boolean deferred;
    private final String indexOrConstraintName;
    private final String tableName;
    private final LanguageConnectionContext lcc;
    private final UUID constraintId;
    private BackingStoreHashtable deferredDuplicates;

    public UniqueIndexSortObserver(LanguageConnectionContext lcc, UUID constraintId, boolean doClone, boolean deferrable, boolean deferred, String indexOrConstraintName, ExecRow execRow, boolean reuseWrappers, String tableName) {
        super(doClone, !deferred, execRow, reuseWrappers);
        this.lcc = lcc;
        this.constraintId = constraintId;
        this.deferrable = deferrable;
        this.deferred = deferred;
        this.indexOrConstraintName = indexOrConstraintName;
        this.tableName = tableName;
    }

    @Override
    public DataValueDescriptor[] insertDuplicateKey(DataValueDescriptor[] in, DataValueDescriptor[] dup) throws StandardException {
        StandardException se = null;
        se = StandardException.newException((String)"23505", (Object[])new Object[]{this.indexOrConstraintName, this.tableName});
        throw se;
    }

    @Override
    public boolean deferred() {
        return this.deferred;
    }

    @Override
    public boolean deferrable() {
        return this.deferrable;
    }

    @Override
    public void rememberDuplicate(DataValueDescriptor[] row) throws StandardException {
        this.deferredDuplicates = DeferredConstraintsMemory.rememberDuplicate(this.lcc, this.deferredDuplicates, this.constraintId, row);
    }
}

