"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCommonError = exports.GenericEntityPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _search_strategy = require("../../../../common/search_strategy");
var _common = require("../../../entity_analytics/common");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _use_refetch_query_by_id = require("../../../entity_analytics/api/hooks/use_refetch_query_by_id");
var _use_calculate_entity_risk_score = require("../../../entity_analytics/api/hooks/use_calculate_entity_risk_score");
var _types = require("../../../../common/entity_analytics/types");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _use_open_generic_entity_details_left_panel = require("./hooks/use_open_generic_entity_details_left_panel");
var _use_get_generic_entity = require("./hooks/use_get_generic_entity");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _use_generic_entity_criticality = require("./hooks/use_generic_entity_criticality");
var _header = require("./header");
var _content = require("./content");
var _footer = require("./footer");
var _risk_inputs_tab = require("../../../entity_analytics/components/entity_details_flyout/tabs/risk_inputs/risk_inputs_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/generic_right/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isCommonError = error => {
  var _error$body, _error$body2, _error$body3;
  // @ts-ignore TS2339: Property body does not exist on type {}
  if (!(error !== null && error !== void 0 && error.body) || !(error !== null && error !== void 0 && (_error$body = error.body) !== null && _error$body !== void 0 && _error$body.error) || !(error !== null && error !== void 0 && (_error$body2 = error.body) !== null && _error$body2 !== void 0 && _error$body2.message) || !(error !== null && error !== void 0 && (_error$body3 = error.body) !== null && _error$body3 !== void 0 && _error$body3.statusCode)) {
    return false;
  }
  return true;
};
exports.isCommonError = isCommonError;
const GenericEntityPanel = params => {
  var _getGenericEntity$dat, _getGenericEntity$dat2, _getGenericEntity$dat4, _getGenericEntity$dat5, _getAssetCriticality$;
  const {
    isPreviewMode,
    scopeId,
    isEngineMetadataExist
  } = params;

  // When you destructuring params in the function signature TypeScript loses track
  // of the union type constraints and infers them as potentially undefined
  const {
    getGenericEntity
  } = (0, _use_get_generic_entity.useGetGenericEntity)(params);
  const genericInsightsValue = (_getGenericEntity$dat = getGenericEntity.data) === null || _getGenericEntity$dat === void 0 ? void 0 : (_getGenericEntity$dat2 = _getGenericEntity$dat._source) === null || _getGenericEntity$dat2 === void 0 ? void 0 : _getGenericEntity$dat2.entity.id;
  const {
    getAssetCriticality
  } = (0, _use_generic_entity_criticality.useGenericEntityCriticality)({
    enabled: !!genericInsightsValue,
    idField: _types.EntityIdentifierFields.generic,
    // @ts-ignore since this query is only enabled when the entity.id exists, we can safely assume that idValue won't be undefined
    idValue: genericInsightsValue
  });
  const {
    openGenericEntityDetails
  } = (0, _use_open_generic_entity_details_left_panel.useOpenGenericEntityDetailsLeftPanel)({
    insightsField: 'related.entity',
    insightsValue: genericInsightsValue || '',
    ...params
  });
  const openGenericEntityDetailsPanelByPath = path => {
    return openGenericEntityDetails(path);
  };
  const genericNameFilterQuery = (0, _react.useMemo)(() => genericInsightsValue ? (0, _search_strategy.buildEntityNameFilter)(_types.EntityType.generic, [genericInsightsValue]) : undefined, [genericInsightsValue]);
  const riskScoreState = (0, _use_risk_score.useRiskScore)({
    riskEntity: _types.EntityType.generic,
    filterQuery: genericNameFilterQuery,
    onlyLatest: false,
    pagination: _common.FIRST_RECORD_PAGINATION
  });
  const {
    refetch
  } = riskScoreState;
  const refetchRiskInputsTab = (0, _use_refetch_query_by_id.useRefetchQueryById)(_risk_inputs_tab.RISK_INPUTS_TAB_QUERY_ID);
  const refetchRiskScore = (0, _react.useCallback)(() => {
    refetch();
    refetchRiskInputsTab === null || refetchRiskInputsTab === void 0 ? void 0 : refetchRiskInputsTab();
  }, [refetch, refetchRiskInputsTab]);
  const {
    calculateEntityRiskScore
  } = (0, _use_calculate_entity_risk_score.useCalculateEntityRiskScore)(_types.EntityType.generic, genericInsightsValue || '', {
    onSuccess: refetchRiskScore
  });
  (0, _react.useEffect)(() => {
    var _getGenericEntity$dat3;
    if ((_getGenericEntity$dat3 = getGenericEntity.data) !== null && _getGenericEntity$dat3 !== void 0 && _getGenericEntity$dat3._id) {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.GENERIC_ENTITY_FLYOUT_OPENED);
    }
  }, [(_getGenericEntity$dat4 = getGenericEntity.data) === null || _getGenericEntity$dat4 === void 0 ? void 0 : _getGenericEntity$dat4._id]);
  if (!isEngineMetadataExist) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      iconType: "warning",
      "data-test-subj": "generic-right-flyout-error-prompt-missing-engineMetadataType",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.genericEntityFlyout.missingEngineMetadataType.errorTitle",
        defaultMessage: "Unable to load entity: 'EngineMetadata.Type' is missing or not set.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 15
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }));
  }
  if (getGenericEntity.isLoading || getAssetCriticality.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      css: {
        position: 'absolute',
        inset: '50%'
      },
      "data-test-subj": "generic-flyout-loading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }));
  }
  if (!((_getGenericEntity$dat5 = getGenericEntity.data) !== null && _getGenericEntity$dat5 !== void 0 && _getGenericEntity$dat5._source) || getGenericEntity.isError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      iconType: "warning",
      "data-test-subj": "generic-right-flyout-error-prompt",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.genericEntityFlyout.errorTitle",
        defaultMessage: "Unable to load entity",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 15
        }
      })),
      body: isCommonError(getGenericEntity.error) ? /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.genericEntityFlyout.errorBody",
        defaultMessage: "{error} {statusCode}: {body}",
        values: {
          error: getGenericEntity.error.body.error,
          statusCode: getGenericEntity.error.body.statusCode,
          body: getGenericEntity.error.body.message
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 17
        }
      })) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }));
  }
  const source = getGenericEntity.data._source;
  const entity = getGenericEntity.data._source.entity;
  const fields = getGenericEntity.data.fields || {};
  const assetCriticalityLevel = (_getAssetCriticality$ = getAssetCriticality.data) === null || _getAssetCriticality$ === void 0 ? void 0 : _getAssetCriticality$.criticality_level;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: true,
    expandDetails: () => openGenericEntityDetailsPanelByPath({
      tab: _left_panel_header.EntityDetailsLeftPanelTab.FIELDS_TABLE
    }),
    isPreviewMode: isPreviewMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_header.GenericEntityFlyoutHeader, {
    entity: entity,
    source: source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_content.GenericEntityFlyoutContent, {
    source: source,
    openGenericEntityDetailsPanelByPath: openGenericEntityDetailsPanelByPath,
    insightsField: 'related.entity',
    insightsValue: source.entity.id,
    onAssetCriticalityChange: calculateEntityRiskScore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_footer.GenericEntityFlyoutFooter, {
    scopeId: scopeId,
    isPreviewMode: isPreviewMode !== null && isPreviewMode !== void 0 ? isPreviewMode : false,
    entityId: entity.id,
    entityFields: fields,
    assetCriticalityLevel: assetCriticalityLevel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }));
};
exports.GenericEntityPanel = GenericEntityPanel;
GenericEntityPanel.displayName = 'GenericEntityPanel';