"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpandableValues = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_ARRAY = [];
/**
 * Hook that manages "Show more / Show less" behavior for lists of values.
 * Returns the visible values, hidden values, and expansion state.
 */
const useExpandableValues = ({
  values,
  displayValuesLimit = 2
}) => {
  var _values$length2;
  const [isContentExpanded, setIsContentExpanded] = (0, _react.useState)(false);
  const toggleContentExpansion = (0, _react.useCallback)(() => setIsContentExpanded(currentIsOpen => !currentIsOpen), []);
  const {
    visibleValues,
    overflownValues,
    isContentTooLarge
  } = (0, _react.useMemo)(() => {
    var _values$length;
    const total = (_values$length = values === null || values === void 0 ? void 0 : values.length) !== null && _values$length !== void 0 ? _values$length : 0;
    const hasLimit = displayValuesLimit && displayValuesLimit > 0 && displayValuesLimit < total;
    if (!values || total === 0) {
      return {
        visibleValues: EMPTY_ARRAY,
        overflownValues: EMPTY_ARRAY,
        isContentTooLarge: false
      };
    }
    if (!hasLimit) {
      return {
        visibleValues: values,
        overflownValues: EMPTY_ARRAY,
        isContentTooLarge: false
      };
    }
    return {
      visibleValues: values.slice(0, displayValuesLimit),
      overflownValues: values.slice(displayValuesLimit),
      isContentTooLarge: true
    };
  }, [values, displayValuesLimit]);
  const hasMultipleValues = ((_values$length2 = values === null || values === void 0 ? void 0 : values.length) !== null && _values$length2 !== void 0 ? _values$length2 : 0) > 1;
  return {
    visibleValues,
    overflownValues,
    isContentExpanded,
    isContentTooLarge,
    hasMultipleValues,
    toggleContentExpansion
  };
};
exports.useExpandableValues = useExpandableValues;