"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelligenceOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _local_storage = require("../../shared/constants/local_storage");
var _kibana = require("../../../../common/lib/kibana");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_fetch_threat_intelligence = require("../hooks/use_fetch_threat_intelligence");
var _insights_summary_row = require("./insights_summary_row");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _left = require("../../left");
var _threat_intelligence_details = require("../../left/components/threat_intelligence_details");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/threat_intelligence_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HEADER_TITLE = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatIntelligenceTitle",
  defaultMessage: "Threat intelligence",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 3
  }
});
const HEADER_TOOLTIP = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatIntelligenceTooltip",
  defaultMessage: "Show all threat intelligence",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
});
const DEFAULT_TIME_RANGE_LABEL = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.defaultTimeRangeApplied.badgeLabel",
  defaultMessage: "Time range applied",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 3
  }
});
const CUSTOM_TIME_RANGE_LABEL = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.customTimeRangeApplied.badgeLabel",
  defaultMessage: "Custom time range applied",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 3
  }
});
const DEFAULT_TIME_RANGE_TOOLTIP = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.defaultTimeRangeAppliedTooltipLabel",
  defaultMessage: "Threat intelligence helps you to find current and emerging threats in your environment over the last 30 days. To choose a custom time range, click the section title, then use the date time picker in the left panel.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 3
  }
});
const CUSTOM_TIME_RANGE_TOOLTIP = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.customTimeRangeAppliedTooltipLabel",
  defaultMessage: "Threat intelligence helps you to find current and emerging threats in your environment during the time range that you chose. To choose a different custom time range, click the section title, then use the date time picker in the left panel.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 3
  }
});

/**
 * Threat intelligence section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const ThreatIntelligenceOverview = () => {
  const {
    dataFormattedForFieldBrowser,
    isPreviewMode
  } = (0, _context.useDocumentDetailsContext)();
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const timeSavedInLocalStorage = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.THREAT_INTELLIGENCE_TIME_RANGE);
  const goToThreatIntelligenceTab = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInsightsTab,
    subTab: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID
  });
  const {
    loading,
    threatMatchesCount,
    threatEnrichmentsCount
  } = (0, _use_fetch_threat_intelligence.useFetchThreatIntelligence)({
    dataFormattedForFieldBrowser
  });
  const link = (0, _react.useMemo)(() => ({
    callback: goToThreatIntelligenceTab,
    tooltip: HEADER_TOOLTIP
  }), [goToThreatIntelligenceTab]);
  const threatMatchCountText = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatMatchDescription",
    defaultMessage: "Threat {count, plural, one {match} other {matches}} detected",
    values: {
      count: threatMatchesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), [threatMatchesCount]);
  const threatEnrichmentsCountText = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatEnrichmentDescription",
    defaultMessage: "{count, plural, one {Field} other {Fields}} enriched with threat intelligence",
    values: {
      count: threatEnrichmentsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), [threatEnrichmentsCount]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: HEADER_TITLE,
      link,
      iconType: !isPreviewMode ? 'arrowStart' : undefined,
      headerContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: timeSavedInLocalStorage ? CUSTOM_TIME_RANGE_TOOLTIP : DEFAULT_TIME_RANGE_TOOLTIP,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        iconSide: "left",
        iconType: "clock",
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 13
        }
      }, timeSavedInLocalStorage ? CUSTOM_TIME_RANGE_LABEL : DEFAULT_TIME_RANGE_LABEL))
    },
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID,
    content: {
      loading
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": `${_test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID}Container`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    text: threatMatchCountText,
    value: threatMatchesCount,
    expandedSubTab: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_THREAT_MATCHES_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    text: threatEnrichmentsCountText,
    value: threatEnrichmentsCount,
    expandedSubTab: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_ENRICHED_WITH_THREAT_INTELLIGENCE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  })));
};
exports.ThreatIntelligenceOverview = ThreatIntelligenceOverview;
ThreatIntelligenceOverview.displayName = 'ThreatIntelligenceOverview';