"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableTabTour = exports.TOUR_STEPS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../common/lib/kibana");
var _local_storage = require("../../shared/constants/local_storage");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/table_tab_tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TOUR_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.tour.tableTabPinning.title', {
  defaultMessage: 'Customize the Table tab'
});
const TOUR_STEPS = exports.TOUR_STEPS = [{
  step: 1,
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.tableTabPinning.title', {
    defaultMessage: 'Pin fields'
  }),
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.tour.tableTabPinning.description",
    defaultMessage: "Pin fields that you're interested in or want to save for later.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  })),
  anchor: `[data-test-subj=${_test_ids.FLYOUT_TABLE_PIN_ACTION_TEST_ID}]`,
  anchorPosition: 'leftCenter'
}, {
  step: 2,
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.tableTabSetting.title', {
    defaultMessage: 'Display and hide fields'
  }),
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.tour.tableTabSetting.description",
    defaultMessage: "Modify the tab's settings to display or hide certain fields. For example, choose to only display highlighted fields.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })),
  anchor: `[data-test-subj=${_test_ids.TABLE_TAB_SETTING_BUTTON_TEST_ID}]`,
  anchorPosition: 'upCenter'
}];
const TOUR_INITIAL_STATE = {
  currentTourStep: 1,
  isTourActive: true,
  tourPopoverWidth: 360,
  tourSubtitle: _i18n.i18n.translate('xpack.securitySolution.flyout.tour.tableTab.title', {
    defaultMessage: 'Customize the Table tab'
  })
};

/**
 * A short tour to guide the user through pinning and field settings on the Table tab.
 */
const TableTabTour = ({
  setIsPopoverOpen
}) => {
  const {
    services: {
      storage
    }
  } = (0, _kibana.useKibana)();
  const [state, setState] = (0, _react.useState)(() => {
    const initialState = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.TABLE_TAB_TOUR);
    return initialState || TOUR_INITIAL_STATE;
  });
  (0, _react.useEffect)(() => {
    storage.set(_local_storage.FLYOUT_STORAGE_KEYS.TABLE_TAB_TOUR, state);
  }, [state, storage]);
  const handleClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
    setState({
      ...state,
      currentTourStep: state.currentTourStep + 1
    });
  }, [state, setIsPopoverOpen, setState]);
  const finishTour = (0, _react.useCallback)(() => {
    setState({
      ...state,
      isTourActive: false
    });
    setIsPopoverOpen(false);
  }, [state, setIsPopoverOpen, setState]);
  if (!state.isTourActive) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, TOUR_STEPS.map((step, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
      anchor: step.anchor,
      anchorPosition: step.anchorPosition,
      content: step.content,
      "data-test-subj": `${_test_ids.TABLE_TAB_TOUR_TEST_ID}-${index + 1}`,
      isStepOpen: state.isTourActive && state.currentTourStep === index + 1,
      key: index,
      minWidth: state.tourPopoverWidth,
      onFinish: finishTour,
      step: index + 1,
      stepsTotal: TOUR_STEPS.length,
      subtitle: TOUR_TITLE,
      title: step.title,
      footerAction:
      // if it's the last step, we don't want to show the next button
      index === TOUR_STEPS.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "success",
        size: "s",
        onClick: finishTour,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 17
        }
      }, 'Finish tour') : [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        color: "text",
        onClick: finishTour,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 19
        }
      }, 'Close tour'), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "success",
        size: "s",
        onClick: handleClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 19
        }
      }, 'Next')],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    });
  }));
};
exports.TableTabTour = TableTabTour;