"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reason = exports.ALERT_REASON_BANNER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../shared/utils");
var _panel_keys = require("../../shared/constants/panel_keys");
var _test_ids = require("./test_ids");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _context = require("../../shared/context");
var _telemetry = require("../../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/reason.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_REASON_BANNER = exports.ALERT_REASON_BANNER = {
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.reason.alertReasonPreviewTitle', {
    defaultMessage: 'Preview alert reason'
  }),
  backgroundColor: 'warning',
  textColor: 'warning'
};

/**
 * Displays the information provided by the rowRenderer. Supports multiple types of documents.
 */
const Reason = () => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    eventId,
    indexName,
    scopeId,
    dataFormattedForFieldBrowser,
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const alertReason = (0, _utils.getField)(getFieldsData(_ruleDataUtils.ALERT_REASON));
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openRulePreview = (0, _react.useCallback)(() => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsAlertReasonPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId,
        banner: ALERT_REASON_BANNER
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'preview'
    });
  }, [eventId, openPreviewPanel, indexName, scopeId, telemetry]);
  const viewPreview = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "expand",
    onClick: openRulePreview,
    iconSide: "right",
    "data-test-subj": _test_ids.REASON_DETAILS_PREVIEW_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.reason.alertReasonButtonAriaLabel', {
      defaultMessage: 'Show full reason'
    }),
    disabled: !alertReason,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.alertReasonButtonLabel",
    defaultMessage: "Show full reason",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }))), [alertReason, openRulePreview]);
  const alertReasonText = alertReason ? alertReason : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.noReasonDescription",
    defaultMessage: "There's no source event information for this alert.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.REASON_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, isAlert ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.alertReasonTitle",
    defaultMessage: "Alert reason",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 21
    }
  }))), viewPreview) : /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.documentReasonTitle",
    defaultMessage: "Document reason",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.REASON_DETAILS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, isAlert ? alertReasonText : '-'));
};
exports.Reason = Reason;
Reason.displayName = 'Reason';