"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFindAlerts = void 0;
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFindAlerts = searchService => async ({
  signal,
  alertIds,
  from,
  size,
  sort
}) => {
  return new Promise((resolve, reject) => {
    const $subscription = searchService.search({
      params: {
        body: {
          query: {
            ids: {
              values: alertIds
            }
          },
          from,
          size,
          sort,
          fields: ['*'],
          _source: false
        }
      }
    }, {
      abortSignal: signal
    }).subscribe({
      next: response => {
        if (!(0, _public.isRunningResponse)(response)) {
          $subscription.unsubscribe();
          resolve(response.rawResponse);
        }
      },
      error: err => {
        $subscription.unsubscribe();
        reject(new Error(`Error while loading alerts`));
      }
    });
  });
};
exports.createFindAlerts = createFindAlerts;