"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THREAT_DETAILS_ROW_STRING_VALUE_TEST_ID = exports.THREAT_DETAILS_ROW_LINK_VALUE_TEST_ID = exports.THREAT_DETAILS_ROW_FIELD_TEST_ID = exports.EnrichmentAccordion = exports.ENRICHMENT_ACCORDION_LINK_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _test_ids = require("./test_ids");
var _use_investigation_enrichment = require("../../shared/hooks/use_investigation_enrichment");
var _inspect = require("../../../../common/components/inspect");
var _threat_intelligence = require("../../shared/utils/threat_intelligence");
var _threat_details_view_enrichment_button_content = require("./threat_details_view_enrichment_button_content");
var _constants = require("../../../../../common/cti/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/threat_details_view_enrichment_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledH5 = _styled.default.h5`
  line-height: 1.7rem;
`;
const ENRICHMENT_ACCORDION_LINK_TEST_ID = exports.ENRICHMENT_ACCORDION_LINK_TEST_ID = 'enrichementAccordion';
const THREAT_DETAILS_ROW_FIELD_TEST_ID = exports.THREAT_DETAILS_ROW_FIELD_TEST_ID = 'threatDetailsRowField';
const THREAT_DETAILS_ROW_LINK_VALUE_TEST_ID = exports.THREAT_DETAILS_ROW_LINK_VALUE_TEST_ID = 'threatDetailsRowLinkValue';
const THREAT_DETAILS_ROW_STRING_VALUE_TEST_ID = exports.THREAT_DETAILS_ROW_STRING_VALUE_TEST_ID = 'threatDetailsRowStringValue';
const INVESTIGATION_QUERY_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.investigationTimeQueryTitle', {
  defaultMessage: 'Enrichment with Threat Intelligence'
});

/**
 * Defines the fields displayed on each row of the table
 */

const columns = [{
  field: 'title',
  truncateText: false,
  render: title => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": THREAT_DETAILS_ROW_FIELD_TEST_ID,
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StyledH5, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, title)),
  width: '220px',
  name: ''
}, {
  field: 'description',
  truncateText: false,
  render: description => {
    const {
      fieldName,
      value
    } = description;
    const renderedValue = fieldName.match(_constants.REFERENCE) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }, value.map((val, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": THREAT_DETAILS_ROW_LINK_VALUE_TEST_ID,
      key: key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: val,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    }, val)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, value.map((val, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": THREAT_DETAILS_ROW_STRING_VALUE_TEST_ID,
      key: key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, val))));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "message-tool-tip",
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 17
        }
      }, fieldName))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, renderedValue);
  },
  name: ''
}];
/**
 * Displays the enrichment data in an accordion
 */
const EnrichmentAccordion = exports.EnrichmentAccordion = /*#__PURE__*/(0, _react.memo)(({
  enrichment,
  index
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    id = `threat-details-item`,
    field,
    feedName,
    type,
    value
  } = (0, _threat_intelligence.getEnrichmentIdentifiers)(enrichment);
  const accordionId = `${id}${field}`;
  const showInspectButton = (0, _react.useMemo)(() => (0, _threat_intelligence.isInvestigationTimeEnrichment)(type), [type]);
  const items = (0, _react.useMemo)(() => (0, _threat_intelligence.buildThreatDetailsItems)(enrichment), [enrichment]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": ENRICHMENT_ACCORDION_LINK_TEST_ID,
    id: accordionId,
    key: accordionId,
    initialIsOpen: true,
    arrowDisplay: "right",
    buttonContent: /*#__PURE__*/_react.default.createElement(_threat_details_view_enrichment_button_content.EnrichmentButtonContent, {
      field: field,
      feedName: feedName,
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 22
      }
    }),
    extraAction: showInspectButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
      queryId: _use_investigation_enrichment.QUERY_ID,
      title: INVESTIGATION_QUERY_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    })),
    css: (0, _react2.css)`
        .euiAccordion__triggerWrapper {
          background: ${euiTheme.colors.lightestShade};
          border-radius: ${euiTheme.size.xs};
          height: ${euiTheme.size.xl};
          margin-bottom: ${euiTheme.size.s};
          padding-left: ${euiTheme.size.s};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: columns,
    compressed: true,
    "data-test-subj": `${_test_ids.THREAT_INTELLIGENCE_ENRICHMENTS_ACCORDION_TABLE_TEST_ID}-${index}`,
    items: items,
    css: (0, _react2.css)`
          .euiTableHeaderCell,
          .euiTableRowCell {
            border: none;
          }
          .euiTableHeaderCell .euiTableCellContent {
            padding: 0;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }));
});
EnrichmentAccordion.displayName = 'EnrichmentAccordion';