"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttackDetails = void 0;
var _constants = require("../../../data_view_manager/constants");
var _use_browser_fields = require("../../../data_view_manager/hooks/use_browser_fields");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _details = require("../../../timelines/containers/details");
var _use_get_fields_data = require("../../document_details/shared/hooks/use_get_fields_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAttackDetails = ({
  attackId,
  indexName
}) => {
  // Now we are retrieving all the browserFields from the data view associated with the attacks page
  // TODO following the useCreateEaseAlertsDataView pattern, we should create a specific data view for the attack details
  // https://github.com/elastic/kibana/issues/244205
  const pageScope = _constants.PageScope.attacks;
  const {
    dataView
  } = (0, _use_data_view.useDataView)(pageScope);
  const browserFields = (0, _use_browser_fields.useBrowserFields)(pageScope);
  const runtimeMappings = dataView === null || dataView === void 0 ? void 0 : dataView.getRuntimeMappings();
  const [loading, dataFormattedForFieldBrowser, searchHit] = (0, _details.useTimelineEventsDetails)({
    indexName: indexName || '',
    eventId: attackId || '',
    runtimeMappings,
    skip: !attackId
  });
  const {
    getFieldsData
  } = (0, _use_get_fields_data.useGetFieldsData)({
    fieldsData: searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields
  });
  return {
    browserFields,
    dataFormattedForFieldBrowser,
    searchHit,
    getFieldsData,
    loading
  };
};
exports.useAttackDetails = useAttackDetails;