"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttackDetailsContext = exports.AttackDetailsProvider = exports.AttackDetailsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _flyout_loading = require("../shared/components/flyout_loading");
var _flyout_error = require("../shared/components/flyout_error");
var _use_attack_details = require("./hooks/use_attack_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/attack_details/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A context provider for Attack Details flyout
 */
const AttackDetailsContext = exports.AttackDetailsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const AttackDetailsProvider = exports.AttackDetailsProvider = /*#__PURE__*/(0, _react.memo)(({
  attackId,
  indexName,
  children
}) => {
  // data view side: browserFields + field-browser data
  const {
    browserFields,
    dataFormattedForFieldBrowser,
    searchHit,
    getFieldsData,
    loading
  } = (0, _use_attack_details.useAttackDetails)({
    attackId,
    indexName
  });
  const contextValue = (0, _react.useMemo)(() => attackId && browserFields && dataFormattedForFieldBrowser && indexName && searchHit ? {
    attackId,
    browserFields,
    indexName,
    searchHit,
    getFieldsData,
    dataFormattedForFieldBrowser
  } : undefined, [attackId, browserFields, indexName, dataFormattedForFieldBrowser, searchHit, getFieldsData]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 14
      }
    });
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(AttackDetailsContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, children);
});
AttackDetailsProvider.displayName = 'AttackDetailsProvider';
const useAttackDetailsContext = () => {
  const contextValue = (0, _react.useContext)(AttackDetailsContext);
  if (!contextValue) {
    throw new Error('AttackDetailsContext can only be used within AttackDetailsContext provider');
  }
  return contextValue;
};
exports.useAttackDetailsContext = useAttackDetailsContext;