"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFieldValueCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _formatted_field = require("../../../timelines/components/timeline/body/renderers/formatted_field");
var _get_field_format = require("../../document_details/right/utils/get_field_format");
var _use_expandable_values = require("../../document_details/shared/hooks/use_expandable_values");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/attack_details/components/table_field_value_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders the value of a field in the second column of the table
 */
const TableFieldValueCell = exports.TableFieldValueCell = /*#__PURE__*/(0, _react.memo)(({
  data,
  attackId,
  fieldFromBrowserField,
  values,
  displayValuesLimit = 2
}) => {
  const {
    visibleValues,
    overflownValues,
    isContentExpanded,
    isContentTooLarge,
    toggleContentExpansion
  } = (0, _use_expandable_values.useExpandableValues)({
    values,
    displayValuesLimit
  });
  if (values == null) {
    return null;
  }
  const renderValue = (value, i) => {
    if (fieldFromBrowserField == null) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${i}-${value}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        key: `${i}-${value}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      }, value));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: `${i}-${value}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
      contextId: `${attackId}-${data.field}-${i}-${value}`,
      eventId: attackId,
      fieldFormat: (0, _get_field_format.getFieldFormat)(data),
      fieldName: data.field,
      fieldFromBrowserField: fieldFromBrowserField,
      fieldType: data.type,
      isAggregatable: fieldFromBrowserField.aggregatable,
      isObjectArray: data.isObjectArray,
      value: value,
      truncate: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `attack-field-${data.field}`,
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, visibleValues.map((value, i) => renderValue(value, i)), isContentExpanded && overflownValues.map((value, i) =>
  // keys stay unique
  renderValue(value, i + visibleValues.length)), isContentTooLarge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
              align-self: flex-start;
              width: auto;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    onClick: toggleContentExpansion,
    "data-test-subj": "attack-field-toggle-show-more-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, isContentExpanded ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.alertsHighlightedField.showMore",
    defaultMessage: "Show less",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.alertsHighlightedField.showLess",
    defaultMessage: "Show more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }))));
});
TableFieldValueCell.displayName = 'TableFieldValueCell';