"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../../data_view_manager/constants");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kuery = require("../../../../common/lib/kuery");
var _alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status");
var _use_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _constants2 = require("../../../../common/store/inputs/constants");
var _use_selector = require("../../../../common/hooks/use_selector");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _filters_global = require("../../../../common/components/filters_global");
var _header_page = require("../../../../common/components/header_page");
var _last_event_time = require("../../../../common/components/last_event_time");
var _use_anomalies_table_data = require("../../../../common/components/ml/anomaly/use_anomalies_table_data");
var _network_to_criteria = require("../../../../common/components/ml/criteria/network_to_criteria");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _manage_query = require("../../../../common/components/page/manage_query");
var _flow_target_select_connected = require("../../components/flow_target_select_connected");
var _details = require("../../components/details");
var _search_bar = require("../../../../common/components/search_bar");
var _page_loader = require("../../../../common/components/page_loader");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _details2 = require("../../containers/details");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../../../../common/lib/helpers");
var _store = require("../../../../common/store");
var _actions = require("../../../../common/store/inputs/actions");
var _actions2 = require("../../store/actions");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _store2 = require("../../store");
var _types = require("../../../../app/types");
var _containers = require("../../../../sourcerer/containers");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _empty_prompt = require("../../../../common/components/empty_prompt");
var _tab_navigation = require("../../../../common/components/navigation/tab_navigation");
var _utils = require("../../../../common/components/visualization_actions/utils");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _alert_count_by_status = require("../../../../common/components/alert_count_by_status");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _nav_tabs = require("./nav_tabs");
var _details_tabs = require("./details_tabs");
var _use_installed_security_jobs = require("../../../../common/components/ml/hooks/use_installed_security_jobs");
var _cell_actions = require("../../../../common/components/cell_actions");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkDetailsManage = (0, _manage_query.manageQuery)(_details.IpOverview);
const NetworkDetailsComponent = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    to,
    from,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    detailName,
    flowTarget
  } = (0, _reactRouterDom.useParams)();
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    hasAlertsRead,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const canReadAlerts = hasAlertsRead && hasIndexRead;
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const type = _store2.networkModel.NetworkType.details;
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants2.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  (0, _react.useEffect)(() => {
    dispatch((0, _actions2.setNetworkDetailsTablesActivePageToZero)());
  }, [detailName, dispatch]);
  const {
    indicesExist: oldIndicesExist,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_constants.PageScope.explore);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.PageScope.explore);
  const indicesExist = newDataViewPickerEnabled ? experimentalDataView.hasMatchedIndices() : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const ip = (0, _helpers.decodeIpv6)(detailName);
  const networkDetailsFilter = (0, _react.useMemo)(() => (0, _utils.getNetworkDetailsPageFilter)(ip), [ip]);
  const [rawFilteredQuery, kqlError] = (0, _react.useMemo)(() => {
    try {
      return [(0, _esQuery.buildEsQuery)(newDataViewPickerEnabled ? experimentalDataView : (0, _kuery.dataViewSpecToViewBase)(oldSourcererDataViewSpec), [query], [...networkDetailsFilter, ...globalFilters], (0, _common.getEsQueryConfig)(uiSettings))];
    } catch (e) {
      return [undefined, e];
    }
  }, [experimentalDataView, globalFilters, networkDetailsFilter, newDataViewPickerEnabled, oldSourcererDataViewSpec, query, uiSettings]);
  const additionalFilters = (0, _react.useMemo)(() => rawFilteredQuery ? [rawFilteredQuery] : [], [rawFilteredQuery]);
  const stringifiedAdditionalFilters = JSON.stringify(rawFilteredQuery);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: _details2.ID,
    filterQuery: stringifiedAdditionalFilters,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const [loading, {
    id,
    inspect,
    networkDetails,
    refetch
  }] = (0, _details2.useNetworkDetails)({
    skip: isInitializing,
    filterQuery: stringifiedAdditionalFilters,
    indexNames: selectedPatterns,
    ip
  });
  const {
    jobNameById
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobNameById)();
  const jobIds = (0, _react.useMemo)(() => Object.keys(jobNameById), [jobNameById]);
  const [isLoadingAnomaliesData, anomaliesData] = (0, _use_anomalies_table_data.useAnomaliesTableData)({
    criteriaFields: (0, _network_to_criteria.networkToCriteria)(detailName, flowTarget),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    jobIds,
    aggregationInterval: 'auto'
  });
  const entityFilter = (0, _react.useMemo)(() => ({
    field: `${flowTarget}.ip`,
    value: detailName
  }), [detailName, flowTarget]);
  const indexPattern = (0, _react.useMemo)(() => {
    return newDataViewPickerEnabled ? experimentalDataView || {
      title: '',
      fields: []
    } : (0, _kuery.dataViewSpecToViewBase)(oldSourcererDataViewSpec);
  }, [experimentalDataView, newDataViewPickerEnabled, oldSourcererDataViewSpec]);
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "network-details-page",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataView: experimentalDataView,
    id: _constants2.InputsModelId.global,
    sourcererDataViewSpec: oldSourcererDataViewSpec // TODO remove when we remove the newDataViewPickerEnabled feature flag
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.ipDetails,
      indexNames: selectedPatterns,
      ip: ip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 17
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: ip,
        field: `${flowTarget}.ip`
      },
      mode: _cell_actions.CellActionsMode.HOVER_DOWN,
      visibleCellActions: 5,
      triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 17
      }
    }, ip),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_flow_target_select_connected.FlowTargetSelectConnected, {
    flowTarget: flowTarget,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(NetworkDetailsManage, {
    id: id,
    inspect: inspect,
    ip: ip,
    isInDetailsSidePanel: false,
    data: networkDetails,
    anomaliesData: anomaliesData,
    loading: loading,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    type: type,
    flowTarget: flowTarget,
    refetch: refetch,
    setQuery: setQuery,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById,
    scopeId: _constants.PageScope.explore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  }), canReadAlerts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    entityFilter: entityFilter,
    additionalFilters: additionalFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_count_by_status.AlertCountByRuleByStatus, {
    entityFilter: entityFilter,
    signalIndexName: signalIndexName,
    additionalFilters: additionalFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _nav_tabs.navTabsNetworkDetails)(ip, (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities), flowTarget),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_details_tabs.NetworkDetailsTabs, {
    ip: ip,
    endDate: to,
    startDate: from,
    filterQuery: stringifiedAdditionalFilters,
    indexNames: selectedPatterns,
    skip: isInitializing || !!kqlError,
    setQuery: setQuery,
    indexPattern: indexPattern,
    flowTarget: flowTarget,
    networkDetailsFilter: networkDetailsFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.network,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 7
    }
  }));
};
NetworkDetailsComponent.displayName = 'NetworkDetailsComponent';
const NetworkDetails = exports.NetworkDetails = /*#__PURE__*/_react.default.memo(NetworkDetailsComponent);