"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.UNIQUE_DOMAINS = exports.TOTAL_QUERIES = exports.TOP_DNS_DOMAINS = exports.TOOLTIP = exports.ROWS_5 = exports.ROWS_10 = exports.REGISTERED_DOMAIN = exports.INCLUDE_PTR_RECORDS = exports.DNS_BYTES_OUT = exports.DNS_BYTES_IN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOP_DNS_DOMAINS = exports.TOP_DNS_DOMAINS = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.title', {
  defaultMessage: 'Top DNS domains'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {domain} other {domains}}`
});
exports.UNIT = UNIT;
const TOOLTIP = exports.TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.helperTooltip', {
  defaultMessage: 'This shows DNS protocol traffic only and can be useful for hunting domains used in DNS data exfiltration.'
});
const REGISTERED_DOMAIN = exports.REGISTERED_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.registeredDomain', {
  defaultMessage: 'Registered domain'
});
const TOTAL_QUERIES = exports.TOTAL_QUERIES = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.TotalQueriesTitle', {
  defaultMessage: 'Total queries'
});
const UNIQUE_DOMAINS = exports.UNIQUE_DOMAINS = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.uniqueDomainsTitle', {
  defaultMessage: 'Unique domains'
});
const DNS_BYTES_IN = exports.DNS_BYTES_IN = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.bytesInTitle', {
  defaultMessage: 'DNS bytes in'
});
const DNS_BYTES_OUT = exports.DNS_BYTES_OUT = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.bytesOutTitle', {
  defaultMessage: 'DNS bytes out'
});
const INCLUDE_PTR_RECORDS = exports.INCLUDE_PTR_RECORDS = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.select.includePtrRecords', {
  defaultMessage: 'Include PTR records'
});
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});