"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsHostDetails = void 0;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("../translations"));
var _model = require("../../store/model");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnHostDetailsUrl = (hostName, tabName) => `${_constants.HOSTS_PATH}/name/${hostName}/${tabName}`;
const navTabsHostDetails = ({
  hasMlUserPermissions,
  hostName,
  isEnterprise
}) => {
  const hiddenTabs = [];
  const hostDetailsNavTabs = {
    [_model.HostsTableType.events]: {
      id: _model.HostsTableType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnHostDetailsUrl(hostName, _model.HostsTableType.events),
      disabled: false
    },
    [_model.HostsTableType.authentications]: {
      id: _model.HostsTableType.authentications,
      name: i18n.NAVIGATION_AUTHENTICATIONS_TITLE,
      href: getTabsOnHostDetailsUrl(hostName, _model.HostsTableType.authentications),
      disabled: false
    },
    [_model.HostsTableType.uncommonProcesses]: {
      id: _model.HostsTableType.uncommonProcesses,
      name: i18n.NAVIGATION_UNCOMMON_PROCESSES_TITLE,
      href: getTabsOnHostDetailsUrl(hostName, _model.HostsTableType.uncommonProcesses),
      disabled: false
    },
    [_model.HostsTableType.anomalies]: {
      id: _model.HostsTableType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnHostDetailsUrl(hostName, _model.HostsTableType.anomalies),
      disabled: false
    },
    [_model.HostsTableType.risk]: {
      id: _model.HostsTableType.risk,
      name: i18n.NAVIGATION_HOST_RISK_TITLE,
      href: getTabsOnHostDetailsUrl(hostName, _model.HostsTableType.risk),
      disabled: false
    },
    [_model.HostsTableType.sessions]: {
      id: _model.HostsTableType.sessions,
      name: i18n.NAVIGATION_SESSIONS_TITLE,
      href: getTabsOnHostDetailsUrl(hostName, _model.HostsTableType.sessions),
      disabled: false,
      isBeta: false
    }
  };
  if (!hasMlUserPermissions) {
    hiddenTabs.push(_model.HostsTableType.anomalies);
  }
  if (!isEnterprise) {
    hiddenTabs.push(_model.HostsTableType.sessions);
  }
  return (0, _fp.omit)(hiddenTabs, hostDetailsNavTabs);
};
exports.navTabsHostDetails = navTabsHostDetails;