"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.UNCOMMON_PROCESSES = exports.ROWS_5 = exports.ROWS_10 = exports.NUMBER_OF_INSTANCES = exports.NUMBER_OF_HOSTS = exports.NAME = exports.LAST_USER = exports.LAST_COMMAND = exports.HOSTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNCOMMON_PROCESSES = exports.UNCOMMON_PROCESSES = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.uncommonProcessTable', {
  defaultMessage: 'Uncommon processes'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {process} other {processes}}`
});
exports.UNIT = UNIT;
const HOSTS = exports.HOSTS = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.hostsTitle', {
  defaultMessage: 'Host names'
});
const NUMBER_OF_HOSTS = exports.NUMBER_OF_HOSTS = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.numberOfHostsTitle', {
  defaultMessage: 'Hosts'
});
const NUMBER_OF_INSTANCES = exports.NUMBER_OF_INSTANCES = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.numberOfInstances', {
  defaultMessage: 'Instances'
});
const LAST_COMMAND = exports.LAST_COMMAND = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.lastCommandTitle', {
  defaultMessage: 'Last command'
});
const LAST_USER = exports.LAST_USER = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.lastUserTitle', {
  defaultMessage: 'Last user'
});
const NAME = exports.NAME = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.nameTitle', {
  defaultMessage: 'Process name'
});
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.uncommonProcessTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});