"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginationEuiFlexItem = exports.PaginatedTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../common/constants");
var _header_section = require("../../../common/components/header_section");
var _loader = require("../../../common/components/loader");
var _toasters = require("../../../common/components/toasters");
var i18n = _interopRequireWildcard(require("./translations"));
var _panel = require("../../../common/components/panel");
var _inspect = require("../../../common/components/inspect");
var _query_toggle = require("../../../common/containers/query_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/components/paginated_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_DATA_TEST_SUBJ = 'paginated-table';

// Using telescoping templates to remove 'any' that was polluting downstream column type checks

const PaginatedTableComponent = ({
  activePage,
  columns,
  dataTestSubj = DEFAULT_DATA_TEST_SUBJ,
  headerCount,
  headerFilters,
  titleSize,
  headerSupplement,
  headerTitle,
  headerTooltip,
  headerUnit,
  headerSubtitle,
  id,
  isInspect,
  itemsPerRow,
  limit,
  loading,
  loadPage,
  onChange = _fp.noop,
  pageOfItems,
  setQuerySkip,
  showMorePagesIndicator,
  sorting = null,
  split,
  stackHeader,
  totalCount,
  updateActivePage,
  updateLimitPagination
}) => {
  const [myLoading, setMyLoading] = (0, _react.useState)(loading);
  const [myActivePage, setActivePage] = (0, _react.useState)(activePage);
  const [loadingInitial, setLoadingInitial] = (0, _react.useState)(headerCount === -1);
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const pageCount = Math.ceil(totalCount / limit);
  const dispatchToaster = (0, _toasters.useStateToaster)()[1];
  (0, _react.useEffect)(() => {
    setActivePage(activePage);
  }, [activePage]);
  (0, _react.useEffect)(() => {
    if (headerCount >= 0 && loadingInitial) {
      setLoadingInitial(false);
    }
  }, [loadingInitial, headerCount]);
  (0, _react.useEffect)(() => {
    setMyLoading(loading);
  }, [loading]);
  const onButtonClick = () => {
    setPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopoverOpen(false);
  };
  const goToPage = newActivePage => {
    if ((newActivePage + 1) * limit >= _constants.DEFAULT_MAX_TABLE_QUERY_SIZE) {
      const toast = {
        id: 'PaginationWarningMsg',
        title: headerTitle + i18n.TOAST_TITLE,
        color: 'warning',
        iconType: 'warning',
        toastLifeTimeMs: 10000,
        text: i18n.TOAST_TEXT
      };
      return dispatchToaster({
        type: 'addToaster',
        toast
      });
    }
    setActivePage(newActivePage);
    loadPage(newActivePage);
    updateActivePage(newActivePage);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 5
    }
  }, `${i18n.ROWS}: ${limit}`);
  const rowItems = itemsPerRow && itemsPerRow.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: item.text,
    icon: limit === item.numberOfRow ? 'check' : 'empty',
    onClick: () => {
      closePopover();
      updateLimitPagination(item.numberOfRow);
      updateActivePage(0); // reset results to first page
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }, item.text));
  const PaginationWrapper = showMorePagesIndicator ? PaginationEuiFlexItem : _eui.EuiFlexItem;
  const tableSorting = (0, _react.useMemo)(() => sorting ? {
    sort: {
      field: sorting.field,
      direction: sorting.direction
    }
  } : undefined, [sorting]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(id);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
    // toggle on = skipQuery false
    setQuerySkip(!status);
  }, [setQuerySkip, setToggleStatus]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: !loadingInitial,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    "data-test-subj": `${dataTestSubj}-loading-${loading}`,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    titleSize: titleSize,
    toggleStatus: toggleStatus,
    toggleQuery: toggleQuery,
    headerFilters: headerFilters,
    id: id,
    split: split,
    stackHeader: stackHeader,
    subtitle: !loadingInitial && headerSubtitle ? `${i18n.SHOWING}: ${headerSubtitle}` : headerUnit && `${i18n.SHOWING}: ${headerCount >= 0 ? headerCount.toLocaleString() : 0} ${headerUnit}`,
    title: headerTitle,
    tooltip: headerTooltip,
    inspectMultiple: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 9
    }
  }, !loadingInitial && headerSupplement), toggleStatus && (loadingInitial ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "initialLoadingPanelPaginatedTable",
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(BasicTable, {
    "data-test-subj": "paginated-basic-table",
    columns: columns,
    items: pageOfItems,
    onChange: onChange,
    sorting: tableSorting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(FooterAction, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 17
    }
  }, itemsPerRow && itemsPerRow.length > 0 && totalCount >= itemsPerRow[0].numberOfRow && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "customizablePagination",
    "data-test-subj": "loadingMoreSizeRowPopover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: rowItems,
    "data-test-subj": "loadingMorePickSizeRow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(PaginationWrapper, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 17
    }
  }, totalCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "data-test-subj": "numberedPagination",
    pageCount: pageCount,
    activePage: myActivePage,
    onPageClick: goToPage,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.paginatedTable.pagination.ariaLabel', {
      defaultMessage: 'Table pagination'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 21
    }
  }))), (isInspect || myLoading) && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    overlay: true,
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 44
    }
  })))));
};
const PaginatedTable = exports.PaginatedTable = /*#__PURE__*/(0, _react.memo)(PaginatedTableComponent);
// eslint-disable-line @typescript-eslint/no-explicit-any
const BasicTable = (0, _styledComponents.default)(_eui.EuiBasicTable)`
  tbody {
    th,
    td {
      vertical-align: top;
    }

    .euiTableCellContent {
      display: block;
    }
  }
`; // eslint-disable-line @typescript-eslint/no-explicit-any

BasicTable.displayName = 'BasicTable';
const FooterAction = (0, _styledComponents.default)(_eui.EuiFlexGroup).attrs(() => ({
  alignItems: 'center',
  responsive: false
}))`
  margin-top: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
FooterAction.displayName = 'FooterAction';
const PaginationEuiFlexItem = exports.PaginationEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
    .euiButtonIcon:last-child {
      margin-left: 28px;
    }

    .euiPagination {
      position: relative;
    }

    .euiPagination::before {
      bottom: 0;
      color: ${({
  theme
}) => theme.eui.euiButtonColorDisabled};
      content: '\\2026';
      font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
      padding: 5px ${({
  theme
}) => theme.eui.euiSizeS};
      position: absolute;
      right: ${({
  theme
}) => theme.eui.euiSizeL};
    }
  }
`;
PaginationEuiFlexItem.displayName = 'PaginationEuiFlexItem';