"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USERS_UNIT = exports.USER = exports.SUCCESSES = exports.ROWS_5 = exports.ROWS_10 = exports.NAVIGATION_AUTHENTICATIONS_TITLE = exports.LAST_SUCCESSFUL_TIME = exports.LAST_SUCCESSFUL_SOURCE = exports.LAST_SUCCESSFUL_DESTINATION = exports.LAST_FAILED_TIME = exports.LAST_FAILED_SOURCE = exports.LAST_FAILED_DESTINATION = exports.HOSTS_UNIT = exports.HOST = exports.FAILURES = exports.AUTHENTICATIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTHENTICATIONS = exports.AUTHENTICATIONS = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.authentications', {
  defaultMessage: 'Authentications'
});
const USERS_UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.usersUnit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {user} other {users}}`
});
exports.USERS_UNIT = USERS_UNIT;
const HOSTS_UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.hostsUnit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {host} other {hosts}}`
});
exports.HOSTS_UNIT = HOSTS_UNIT;
const LAST_SUCCESSFUL_SOURCE = exports.LAST_SUCCESSFUL_SOURCE = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.lastSuccessfulSource', {
  defaultMessage: 'Last successful source'
});
const LAST_SUCCESSFUL_DESTINATION = exports.LAST_SUCCESSFUL_DESTINATION = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.lastSuccessfulDestination', {
  defaultMessage: 'Last successful destination'
});
const LAST_SUCCESSFUL_TIME = exports.LAST_SUCCESSFUL_TIME = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.lastSuccessfulTime', {
  defaultMessage: 'Last success'
});
const LAST_FAILED_SOURCE = exports.LAST_FAILED_SOURCE = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.lastFailedSource', {
  defaultMessage: 'Last failed source'
});
const LAST_FAILED_DESTINATION = exports.LAST_FAILED_DESTINATION = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.lastFailedDestination', {
  defaultMessage: 'Last failed destination'
});
const LAST_FAILED_TIME = exports.LAST_FAILED_TIME = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.lastFailedTime', {
  defaultMessage: 'Last failure'
});
const SUCCESSES = exports.SUCCESSES = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.successes', {
  defaultMessage: 'Successes'
});
const FAILURES = exports.FAILURES = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.failures', {
  defaultMessage: 'Failures'
});
const USER = exports.USER = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.user', {
  defaultMessage: 'User'
});
const HOST = exports.HOST = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.host', {
  defaultMessage: 'Host'
});
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.authenticationsTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const NAVIGATION_AUTHENTICATIONS_TITLE = exports.NAVIGATION_AUTHENTICATIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.hosts.navigation.authenticationsTitle', {
  defaultMessage: 'Authentications'
});