"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USEFUL_LINKS = exports.SHOW_USERS_RISK_SCORE = exports.SAVE_FILTERS = exports.SAVE_CHANGES = exports.RUN_RISK_SCORE_ENGINE = exports.RISK_SCORE_RETAINMENT_TOOLTIP = exports.RISK_SCORE_RETAINMENT_CHECKBOX = exports.RISK_SCORE_GENERAL_SECTION = exports.RISK_SCORE_ENGINE_RUN_SUCCESS = exports.RISK_SCORE_ENGINE_RUN_FAILURE = exports.RISK_SCORE_ALERT_CONFIG = exports.RISK_ENGINE_TURNED_ON = exports.RISK_ENGINE_TURNED_OFF = exports.RISK_ENGINE_STATUS_SWITCH_LABEL = exports.RISK_ENGINE_STATUS_ON = exports.RISK_ENGINE_STATUS_OFF = exports.RISK_ENGINE_STATUS = exports.RISK_ENGINE_SAVED_OBJECT_CONFIGURATION_SUCCESS = exports.RISK_ENGINE_NEXT_RUN_TIME = exports.RISK_ENGINE_INCLUDE_CLOSED_ALERTS_DESCRIPTION = exports.REMOVE_FILTER = exports.PREVIEW_MISSING_PERMISSIONS_TITLE = exports.PREVIEW_ERROR_TRY_AGAIN = exports.PREVIEW_ERROR_TITLE = exports.PREVIEW_ERROR_MESSAGE = exports.PREVIEW_DESCRIPTION = exports.PREVIEW = exports.LOADING_RISK_ENGINE_SETTINGS = exports.INCLUDE_CLOSED_ALERTS_LABEL = exports.HIDE_USERS_RISK_SCORE = exports.ERROR_PANEL_TITLE = exports.ERROR_PANEL_MESSAGE = exports.ERROR_PANEL_ERRORS = exports.EA_DOCS_ENTITY_RISK_SCORE = exports.EA_DASHBOARD_LINK = exports.DISCARD_CHANGES = exports.CLOSED_ALERTS_TEXT = exports.APPLIED_TO_RISK_SCORES_OF = exports.ALERT_TIME_WINDOW_LABEL = exports.ALERT_FILTERS_PLACEHOLDER = exports.ALERT_FILTERS_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_USERS_RISK_SCORE = exports.SHOW_USERS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.users.show', {
  defaultMessage: 'Show users'
});
const HIDE_USERS_RISK_SCORE = exports.HIDE_USERS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.users.hide', {
  defaultMessage: 'Hide users'
});
const LOADING_RISK_ENGINE_SETTINGS = exports.LOADING_RISK_ENGINE_SETTINGS = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.loadingRiskEngineSettings', {
  defaultMessage: 'Loading risk engine settings...'
});
const RISK_ENGINE_STATUS = exports.RISK_ENGINE_STATUS = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.status', {
  defaultMessage: 'Status'
});
const RISK_ENGINE_STATUS_ON = exports.RISK_ENGINE_STATUS_ON = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.statusOn', {
  defaultMessage: 'On'
});
const RISK_ENGINE_STATUS_OFF = exports.RISK_ENGINE_STATUS_OFF = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.statusOff', {
  defaultMessage: 'Off'
});
const RISK_SCORE_GENERAL_SECTION = exports.RISK_SCORE_GENERAL_SECTION = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.generalSection', {
  defaultMessage: 'General'
});
const RISK_SCORE_RETAINMENT_CHECKBOX = exports.RISK_SCORE_RETAINMENT_CHECKBOX = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.generalSection.retainmentCheckbox', {
  defaultMessage: 'Retain last calculated risk scores'
});
const RISK_SCORE_RETAINMENT_TOOLTIP = exports.RISK_SCORE_RETAINMENT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.generalSection.retainmentTooltip', {
  defaultMessage: 'When selected, entities keep their last calculated risk score until a new input (for example, an alert) triggers recalculation. When deselected, risk scores reset to zero if no new inputs are found.'
});
const USEFUL_LINKS = exports.USEFUL_LINKS = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.usefulLinks', {
  defaultMessage: 'Useful links'
});
const EA_DASHBOARD_LINK = exports.EA_DASHBOARD_LINK = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.eaDocsDashboard', {
  defaultMessage: 'Entity Analytics dashboard'
});
const EA_DOCS_ENTITY_RISK_SCORE = exports.EA_DOCS_ENTITY_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.eaDocsEntities', {
  defaultMessage: 'How is the risk score calculated?'
});
const PREVIEW_MISSING_PERMISSIONS_TITLE = exports.PREVIEW_MISSING_PERMISSIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.missingPermissionsCallout.title', {
  defaultMessage: 'Insufficient index privileges to preview data'
});
const PREVIEW = exports.PREVIEW = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.preview', {
  defaultMessage: 'Preview'
});
const PREVIEW_DESCRIPTION = exports.PREVIEW_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.previewDescription', {
  defaultMessage: 'The entities shown in the preview are the riskiest found in the 1000 sampled during your chosen timeframe. They may not be the riskiest entities across all of your data.'
});
const PREVIEW_ERROR_TITLE = exports.PREVIEW_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.errorTitle', {
  defaultMessage: 'Preview failed'
});
const PREVIEW_ERROR_MESSAGE = exports.PREVIEW_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.errorMessage', {
  defaultMessage: 'Something went wrong when creating the preview. Please try again.'
});
const PREVIEW_ERROR_TRY_AGAIN = exports.PREVIEW_ERROR_TRY_AGAIN = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.tryAgain', {
  defaultMessage: 'Try again'
});
const ERROR_PANEL_TITLE = exports.ERROR_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.errorPanel.title', {
  defaultMessage: 'There was an error'
});
const ERROR_PANEL_MESSAGE = exports.ERROR_PANEL_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.errorPanel.message', {
  defaultMessage: 'The risk engine status could not be changed. Fix the following and try again:'
});
const ERROR_PANEL_ERRORS = exports.ERROR_PANEL_ERRORS = _i18n.i18n.translate('xpack.securitySolution.riskScore.errorPanel.errors', {
  defaultMessage: 'Errors'
});
const RISK_ENGINE_TURNED_ON = exports.RISK_ENGINE_TURNED_ON = _i18n.i18n.translate('xpack.securitySolution.riskScore.moduleTurnedOn', {
  defaultMessage: 'Entity risk score has been turned on'
});
const RISK_ENGINE_TURNED_OFF = exports.RISK_ENGINE_TURNED_OFF = _i18n.i18n.translate('xpack.securitySolution.riskScore.moduleTurnedOff', {
  defaultMessage: 'Entity risk score has been turned off'
});
const RISK_SCORE_ENGINE_RUN_SUCCESS = exports.RISK_SCORE_ENGINE_RUN_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.riskScore.engineRunSuccess', {
  defaultMessage: 'Entity risk score engine started successfully'
});
const RISK_ENGINE_SAVED_OBJECT_CONFIGURATION_SUCCESS = exports.RISK_ENGINE_SAVED_OBJECT_CONFIGURATION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.riskScore.savedObject.configurationSuccess', {
  defaultMessage: 'Your configuration was updated.'
});
const RISK_SCORE_ALERT_CONFIG = exports.RISK_SCORE_ALERT_CONFIG = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.alertConfig', {
  defaultMessage: 'Alert configuration'
});
const CLOSED_ALERTS_TEXT = exports.CLOSED_ALERTS_TEXT = _i18n.i18n.translate('xpack.securitySolution.riskScore.closedAlertsText', {
  defaultMessage: 'Closed Alerts'
});
const INCLUDE_CLOSED_ALERTS_LABEL = exports.INCLUDE_CLOSED_ALERTS_LABEL = _i18n.i18n.translate('xpack.securitySolution.riskScore.includeClosedAlertsLabel', {
  defaultMessage: 'Include closed alerts in calculation'
});
const RISK_ENGINE_INCLUDE_CLOSED_ALERTS_DESCRIPTION = exports.RISK_ENGINE_INCLUDE_CLOSED_ALERTS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskScore.includeClosedAlertsDescription', {
  defaultMessage: `Enable this option to factor both open and closed alerts into the risk engine
            calculations. Including closed alerts helps provide a more comprehensive risk assessment
            based on past incidents, leading to more accurate scoring and insights.`
});
const RISK_ENGINE_NEXT_RUN_TIME = timeInMinutes => _i18n.i18n.translate('xpack.securitySolution.riskScore.engineNextRunTime', {
  defaultMessage: `Next engine run in {timeInMinutes}`,
  values: {
    timeInMinutes
  }
});
exports.RISK_ENGINE_NEXT_RUN_TIME = RISK_ENGINE_NEXT_RUN_TIME;
const RISK_ENGINE_STATUS_SWITCH_LABEL = exports.RISK_ENGINE_STATUS_SWITCH_LABEL = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskEngineStatus', {
  defaultMessage: 'Risk engine status'
});
const RUN_RISK_SCORE_ENGINE = exports.RUN_RISK_SCORE_ENGINE = _i18n.i18n.translate('xpack.securitySolution.riskScore.runEngine', {
  defaultMessage: 'Run Engine'
});
const SAVE_CHANGES = exports.SAVE_CHANGES = _i18n.i18n.translate('xpack.securitySolution.riskScore.engineSavedObjectsaveChanges', {
  defaultMessage: 'Save Changes'
});
const DISCARD_CHANGES = exports.DISCARD_CHANGES = _i18n.i18n.translate('xpack.securitySolution.riskScore.engineSavedObject.discardChanges', {
  defaultMessage: 'Discard Changes'
});
const RISK_SCORE_ENGINE_RUN_FAILURE = exports.RISK_SCORE_ENGINE_RUN_FAILURE = _i18n.i18n.translate('xpack.securitySolution.riskScore.engineRunSuccess', {
  defaultMessage: 'Entity risk score engine failed to start'
});
const ALERT_TIME_WINDOW_LABEL = exports.ALERT_TIME_WINDOW_LABEL = _i18n.i18n.translate('xpack.securitySolution.riskScore.alertTimeWindowLabel', {
  defaultMessage: 'Alert time window'
});
const ALERT_FILTERS_LABEL = exports.ALERT_FILTERS_LABEL = _i18n.i18n.translate('xpack.securitySolution.riskScore.alertFiltersLabel', {
  defaultMessage: 'Alert filters'
});
const ALERT_FILTERS_PLACEHOLDER = exports.ALERT_FILTERS_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.riskScore.alertFiltersPlaceholder', {
  defaultMessage: 'Filter out alerts using KQL syntax'
});
const APPLIED_TO_RISK_SCORES_OF = exports.APPLIED_TO_RISK_SCORES_OF = _i18n.i18n.translate('xpack.securitySolution.riskScore.appliedToRiskScoresOf', {
  defaultMessage: 'applied to risk scores of'
});
const REMOVE_FILTER = exports.REMOVE_FILTER = _i18n.i18n.translate('xpack.securitySolution.riskScore.removeFilter', {
  defaultMessage: 'Remove filter'
});
const SAVE_FILTERS = exports.SAVE_FILTERS = _i18n.i18n.translate('xpack.securitySolution.riskScore.saveFilters', {
  defaultMessage: 'Save changes'
});