"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _ = require("../app/404");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _constants = require("../../common/constants");
var _entity_analytics_management_page = require("./pages/entity_analytics_management_page");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _entity_store_management_page = require("./pages/entity_store_management_page");
var _entity_analytics_landing = require("./pages/entity_analytics_landing");
var _entity_analytics_privileged_user_monitoring_page = require("./pages/entity_analytics_privileged_user_monitoring_page");
var _entity_analytics_overview_page = require("./pages/entity_analytics_overview_page");
var _entity_threat_hunting_page = require("./pages/entity_threat_hunting_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EntityAnalyticsManagementWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_management_page.EntityAnalyticsManagementPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 5
  }
}));
const EntityAnalyticsManagementContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
    exact: true,
    component: EntityAnalyticsManagementWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsManagementContainer.displayName = 'EntityAnalyticsManagementContainer';
const EntityAnalyticsAssetClassificationContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH,
    exact: true,
    render: ({
      location
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        ...location,
        pathname: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
        search: location.search
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsAssetClassificationContainer.displayName = 'EntityAnalyticsAssetClassificationContainer';
const EntityAnalyticsEntityStoreWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_store_management_page.EntityStoreManagementPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 5
  }
}));
const EntityAnalyticsEntityStoreContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
    exact: true,
    component: EntityAnalyticsEntityStoreWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsEntityStoreContainer.displayName = 'EntityAnalyticsEntityStoreContainer';
const EntityAnalyticsLandingWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 96,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_landing.EntityAnalyticsLandingPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 5
  }
}));
const EntityAnalyticsLandingContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_LANDING_PATH,
    exact: true,
    component: EntityAnalyticsLandingWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsLandingContainer.displayName = 'EntityAnalyticsLandingContainer';
const EntityAnalyticsPrivilegedUserMonitoringWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 113,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_privileged_user_monitoring_page.EntityAnalyticsPrivilegedUserMonitoringPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 114,
    columnNumber: 5
  }
}));
const EntityAnalyticsPrivilegedUserMonitoringContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH,
    exact: true,
    component: EntityAnalyticsPrivilegedUserMonitoringWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsPrivilegedUserMonitoringContainer.displayName = 'EntityAnalyticsPrivilegedUserMonitoringContainer';
const EntityAnalyticsOverviewWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 135,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_analytics_overview_page.OverviewDashboard, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 136,
    columnNumber: 5
  }
}));
const EntityAnalyticsOverviewContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_OVERVIEW_PATH,
    exact: true,
    component: EntityAnalyticsOverviewWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }));
});
EntityAnalyticsOverviewContainer.displayName = 'EntityAnalyticsOverviewContainer';
const EntityThreatHuntingWrapper = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 156,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_entity_threat_hunting_page.EntityThreatHuntingPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 157,
    columnNumber: 5
  }
}));
const EntityThreatHuntingContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ENTITY_ANALYTICS_THREAT_HUNTING_PATH,
    exact: true,
    component: EntityThreatHuntingWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }));
});
EntityThreatHuntingContainer.displayName = 'EntityThreatHuntingContainer';
const routes = exports.routes = [{
  path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsManagementContainer, _constants.SecurityPageName.entityAnalyticsManagement)
}, {
  path: _constants.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH,
  component: EntityAnalyticsAssetClassificationContainer
}, {
  path: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsEntityStoreContainer, _constants.SecurityPageName.entityAnalyticsEntityStoreManagement)
}, {
  path: _constants.ENTITY_ANALYTICS_LANDING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsLandingContainer, _constants.SecurityPageName.entityAnalyticsLanding)
}, {
  path: _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsPrivilegedUserMonitoringContainer, _constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring)
}, {
  path: _constants.ENTITY_ANALYTICS_OVERVIEW_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityAnalyticsOverviewContainer, _constants.SecurityPageName.entityAnalyticsOverview)
}, {
  path: _constants.ENTITY_ANALYTICS_THREAT_HUNTING_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(EntityThreatHuntingContainer, _constants.SecurityPageName.entityAnalyticsThreatHunting)
}];