"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityThreatHuntingPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../app/types");
var _page_wrapper = require("../../common/components/page_wrapper");
var _header_page = require("../../common/components/header_page");
var _empty_prompt = require("../../common/components/empty_prompt");
var _search_bar = require("../../common/components/search_bar");
var _constants = require("../../common/store/inputs/constants");
var _filters_global = require("../../common/components/filters_global");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _containers = require("../../sourcerer/containers");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _page_loader = require("../../common/components/page_loader");
var _constants2 = require("../../data_view_manager/constants");
var _combined_risk_donut_chart = require("../components/threat_hunting/combined_risk_donut_chart");
var _anomalies_placeholder_panel = require("../components/threat_hunting/anomalies_placeholder_panel");
var _threat_hunting_entities_table = require("../components/threat_hunting/threat_hunting_entities_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/pages/entity_threat_hunting_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityThreatHuntingPage = () => {
  var _dataView$matchedIndi2;
  const {
    indicesExist: oldIndicesExist,
    loading: oldIsSourcererLoading,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)(_constants2.PageScope.explore);
  const isSourcererLoading = (0, _react.useMemo)(() => newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading, [newDataViewPickerEnabled, oldIsSourcererLoading, status]);
  const indicesExist = (0, _react.useMemo)(() => {
    var _dataView$matchedIndi;
    return newDataViewPickerEnabled ? !!(dataView !== null && dataView !== void 0 && (_dataView$matchedIndi = dataView.matchedIndices) !== null && _dataView$matchedIndi !== void 0 && _dataView$matchedIndi.length) : oldIndicesExist;
  }, [dataView === null || dataView === void 0 ? void 0 : (_dataView$matchedIndi2 = dataView.matchedIndices) === null || _dataView$matchedIndi2 === void 0 ? void 0 : _dataView$matchedIndi2.length, newDataViewPickerEnabled, oldIndicesExist]);
  const showEmptyPrompt = !indicesExist;
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 12
      }
    });
  }
  if (showEmptyPrompt) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataView: dataView,
    id: _constants.InputsModelId.global,
    sourcererDataViewSpec: oldSourcererDataViewSpec,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "threatHuntingPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.threatHunting.pageTitle",
      defaultMessage: "Entity Threat Hunting",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "threatHuntingLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_combined_risk_donut_chart.CombinedRiskDonutChart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_anomalies_placeholder_panel.AnomaliesPlaceholderPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_threat_hunting_entities_table.ThreatHuntingEntitiesTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalyticsThreatHunting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }));
};
exports.EntityThreatHuntingPage = EntityThreatHuntingPage;