"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsPrivilegedUserMonitoringPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _entity_analytics = require("../../../common/api/entity_analytics");
var _types = require("../../app/types");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _sample_dashboards_panel = require("../components/privileged_user_monitoring_onboarding/sample_dashboards_panel");
var _onboarding_panel = require("../components/privileged_user_monitoring_onboarding/onboarding_panel");
var _privileged_user_monitoring = require("../components/privileged_user_monitoring");
var _filters_global = require("../../common/components/filters_global");
var _search_bar = require("../../common/components/search_bar");
var _constants = require("../../common/store/inputs/constants");
var _use_data_view_spec = require("../../data_view_manager/hooks/use_data_view_spec");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _containers = require("../../sourcerer/containers");
var _header_page = require("../../common/components/header_page");
var _api = require("../api/api");
var _use_privileged_monitoring_health = require("../hooks/use_privileged_monitoring_health");
var _privileged_user_monitoring_manage_data_sources = require("../components/privileged_user_monitoring_manage_data_sources");
var _user_limit_callout = require("../components/user_limit_callout");
var _empty_prompt = require("../../common/components/empty_prompt");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _page_loader = require("../../common/components/page_loader");
var _constants2 = require("../../data_view_manager/constants");
var _force_hidden_timeline = require("../../common/utils/timeline/force_hidden_timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/pages/entity_analytics_privileged_user_monitoring_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const initialState = {
  type: 'fetchingEngineStatus'
};
function reducer(state, action) {
  switch (action.type) {
    case 'SHOW_DASHBOARD':
      return {
        type: 'dashboard',
        onboardingCallout: action.onboardingCallout,
        error: action.error
      };
    case 'SHOW_ONBOARDING':
      return {
        type: 'onboarding'
      };
    case 'INITIALIZING_ENGINE':
      return {
        type: 'initializingEngine',
        userCount: action.userCount,
        initResponse: action.initResponse
      };
    case 'UPDATE_INIT_ENGINE_RESPONSE':
      if (state.type === 'initializingEngine') {
        return {
          ...state,
          initResponse: action.initResponse
        };
      }
      return state;
    case 'SHOW_MANAGE_DATA_SOURCES':
      return {
        type: 'manageDataSources'
      };
    default:
      return state;
  }
}
const EntityAnalyticsPrivilegedUserMonitoringPage = () => {
  var _dataView$matchedIndi2, _engineStatus$data3, _engineStatus$data3$e, _engineStatus$data4, _engineStatus$error2, _state$initResponse;
  const {
    initPrivilegedMonitoringEngine
  } = (0, _api.useEntityAnalyticsRoutes)();
  const [state, dispatch] = (0, _react.useReducer)(reducer, initialState);
  const {
    indicesExist: oldIndicesExist,
    loading: oldIsSourcererLoading,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)(_constants2.PageScope.explore);
  const {
    dataViewSpec
  } = (0, _use_data_view_spec.useDataViewSpec)(_constants2.PageScope.explore); // TODO: newDataViewPicker - this could be left, as the fieldMap spec is actually being used

  const isSourcererLoading = (0, _react.useMemo)(() => newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading, [newDataViewPickerEnabled, oldIsSourcererLoading, status]);
  const indicesExist = (0, _react.useMemo)(() => {
    var _dataView$matchedIndi;
    return newDataViewPickerEnabled ? !!(dataView !== null && dataView !== void 0 && (_dataView$matchedIndi = dataView.matchedIndices) !== null && _dataView$matchedIndi !== void 0 && _dataView$matchedIndi.length) : oldIndicesExist;
  }, [dataView === null || dataView === void 0 ? void 0 : (_dataView$matchedIndi2 = dataView.matchedIndices) === null || _dataView$matchedIndi2 === void 0 ? void 0 : _dataView$matchedIndi2.length, newDataViewPickerEnabled, oldIndicesExist]);
  const sourcererDataView = newDataViewPickerEnabled ? dataViewSpec : oldSourcererDataViewSpec;
  const engineStatus = (0, _use_privileged_monitoring_health.usePrivilegedMonitoringEngineStatus)();
  const initEngineCallBack = (0, _react.useCallback)(async userCount => {
    dispatch({
      type: 'INITIALIZING_ENGINE',
      userCount
    });
    const response = await initPrivilegedMonitoringEngine();
    dispatch({
      type: 'UPDATE_INIT_ENGINE_RESPONSE',
      initResponse: response
    });

    // TODO add status polling when BE API supports it
    if (response.status === 'started') {
      dispatch({
        type: 'SHOW_DASHBOARD',
        onboardingCallout: {
          userCount
        }
      });
    }
  }, [initPrivilegedMonitoringEngine]);
  const onManageUserClicked = (0, _react.useCallback)(() => {
    dispatch({
      type: 'SHOW_MANAGE_DATA_SOURCES'
    });
  }, []);
  const onBackToDashboardClicked = (0, _react.useCallback)(() => {
    dispatch({
      type: 'SHOW_DASHBOARD'
    });
  }, []);
  (0, _react.useEffect)(() => {
    var _engineStatus$data2;
    if (engineStatus.isLoading) {
      return;
    }
    if (engineStatus.isError) {
      var _engineStatus$error$b, _engineStatus$error, _engineStatus$data, _engineStatus$data$er;
      const errorMessage = (_engineStatus$error$b = (_engineStatus$error = engineStatus.error) === null || _engineStatus$error === void 0 ? void 0 : _engineStatus$error.body.message) !== null && _engineStatus$error$b !== void 0 ? _engineStatus$error$b : (_engineStatus$data = engineStatus.data) === null || _engineStatus$data === void 0 ? void 0 : (_engineStatus$data$er = _engineStatus$data.error) === null || _engineStatus$data$er === void 0 ? void 0 : _engineStatus$data$er.message;
      return dispatch({
        type: 'SHOW_DASHBOARD',
        onboardingCallout: undefined,
        error: errorMessage
      });
    }
    if (((_engineStatus$data2 = engineStatus.data) === null || _engineStatus$data2 === void 0 ? void 0 : _engineStatus$data2.status) === _entity_analytics.PrivilegeMonitoringEngineStatusEnum.not_installed) {
      return dispatch({
        type: 'SHOW_ONBOARDING'
      });
    } else {
      return dispatch({
        type: 'SHOW_DASHBOARD'
      });
    }
  }, [(_engineStatus$data3 = engineStatus.data) === null || _engineStatus$data3 === void 0 ? void 0 : (_engineStatus$data3$e = _engineStatus$data3.error) === null || _engineStatus$data3$e === void 0 ? void 0 : _engineStatus$data3$e.message, (_engineStatus$data4 = engineStatus.data) === null || _engineStatus$data4 === void 0 ? void 0 : _engineStatus$data4.status, (_engineStatus$error2 = engineStatus.error) === null || _engineStatus$error2 === void 0 ? void 0 : _engineStatus$error2.body, engineStatus.isError, engineStatus.isLoading]);

  // Hide the timeline bottom bar when the page is in onboarding or initializing state
  (0, _react.useEffect)(() => {
    const hideTimeline = ['onboarding', 'initializingEngine'].includes(state.type);
    const cleanup = (0, _force_hidden_timeline.forceHiddenTimeline)(hideTimeline);
    return cleanup;
  }, [state.type]);
  const fullHeightCSS = (0, _react2.css)`
    min-height: calc(100vh - 240px);
  `;
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 12
      }
    });
  }
  if (!indicesExist) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, state.type === 'dashboard' && /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataView: dataView,
    id: _constants.InputsModelId.global,
    sourcererDataViewSpec: oldSourcererDataViewSpec // TODO remove when we remove the newDataViewPickerEnabled feature flag
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }, state.type === 'fetchingEngineStatus' || isSourcererLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboards.pageTitle",
      defaultMessage: "Privileged user monitoring",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    css: fullHeightCSS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoSecurity",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 19
    }
  })))), state.type === 'onboarding' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: '1144px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_onboarding_panel.PrivilegedUserMonitoringOnboardingPanel, {
    onComplete: initEngineCallBack,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_sample_dashboards_panel.PrivilegedUserMonitoringSampleDashboardsPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  })), state.type === 'initializingEngine' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboards.pageTitle",
      defaultMessage: "Privileged user monitoring",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: fullHeightCSS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, ((_state$initResponse = state.initResponse) === null || _state$initResponse === void 0 ? void 0 : _state$initResponse.status) === 'error' ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.initEngine.error.title",
      defaultMessage: "Error initializing resources",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 23
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      "data-test-subj": "bodyText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.initEngine.error.body",
      defaultMessage: "Sorry, there was an error initializing the privileged monitoring resources. Contact your administrator for help.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 23
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    paddingSize: "l",
    hasShadow: true,
    titleSize: "l",
    color: "plain",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.initEngine.title",
      defaultMessage: "Setting up privileged user monitoring",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 23
      }
    })),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      logo: "logoSecurity",
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 25
      }
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.initEngine.description",
      defaultMessage: "We're currently analyzing your connected data sources to set up comprehensive privileged user monitoring. This may take a few moments.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 17
    }
  }))), state.type === 'dashboard' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboards.pageTitle",
      defaultMessage: "Privileged user monitoring",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 17
      }
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onManageUserClicked,
      iconType: "gear",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboards.manageUsersButton",
      defaultMessage: "Manage data sources",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 19
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_user_limit_callout.UserLimitCallOut, {
    onManageDataSources: onManageUserClicked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_privileged_user_monitoring.PrivilegedUserMonitoring, {
    callout: state.onboardingCallout,
    error: state.error,
    onManageUserClicked: onManageUserClicked,
    sourcererDataView: sourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 13
    }
  })), state.type === 'manageDataSources' && /*#__PURE__*/_react.default.createElement(_privileged_user_monitoring_manage_data_sources.PrivilegedUserMonitoringManageDataSources, {
    onBackToDashboardClicked: onBackToDashboardClicked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 9
    }
  })));
};
exports.EntityAnalyticsPrivilegedUserMonitoringPage = EntityAnalyticsPrivilegedUserMonitoringPage;