"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDefaultRiskIndex = void 0;
var _search_strategy = require("../../../common/search_strategy");
var _use_space_id = require("../../common/hooks/use_space_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDefaultRiskIndex = (onlyLatest = true) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  if (!spaceId) {
    return undefined;
  }
  return (0, _search_strategy.getRiskIndex)(spaceId, onlyLatest);
};
exports.useGetDefaultRiskIndex = useGetDefaultRiskIndex;