"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserLimitCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _use_privileged_monitoring_health = require("../../hooks/use_privileged_monitoring_health");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/user_limit_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UserLimitCallOut = ({
  variant = 'full',
  showOnlyWhenExceeded = false,
  onManageDataSources = _fp.noop
}) => {
  const {
    userStats,
    isLoading
  } = (0, _use_privileged_monitoring_health.useUserLimitStatus)();
  if (isLoading || !userStats) {
    return null;
  }
  const {
    currentCount,
    maxAllowed
  } = userStats;

  // Determine when to show the callout
  const shouldShow = userStats.isLimitExceeded || !showOnlyWhenExceeded && (userStats.isNearLimit || variant === 'compact');
  if (!shouldShow) {
    return null;
  }
  if (userStats.isLimitExceeded) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.exceeded.title",
        defaultMessage: "Performance may be degraded",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      }),
      color: "warning",
      iconType: "alert",
      "data-test-subj": "privileged-user-limit-exceeded-callout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.exceeded.description",
      defaultMessage: "You have {currentCount} privileged users, which exceeds the limit of {maxAllowed}. Remove some privileged users to prevent performance degradation.",
      values: {
        currentCount: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 29
          }
        }, currentCount.toLocaleString()),
        maxAllowed: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 27
          }
        }, maxAllowed.toLocaleString())
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "gear",
      color: "warning",
      onClick: onManageDataSources,
      "data-test-subj": "manage-data-sources-button-exceeded",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.manageDataSources",
      defaultMessage: "Manage data sources",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    })));
  }
  if (userStats.isNearLimit && variant === 'full') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.nearLimit.title",
        defaultMessage: "Approaching user limit",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 11
        }
      }),
      color: "warning",
      iconType: "alert",
      "data-test-subj": "privileged-user-near-limit-callout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.nearLimit.description",
      defaultMessage: "You're currently monitoring {currentCount} out of {maxAllowed} allowed privileged users ({utilizationPercentage}% of limit). Consider removing some users to prevent performance degradation.",
      values: {
        currentCount: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 29
          }
        }, currentCount.toLocaleString()),
        maxAllowed: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 27
          }
        }, maxAllowed.toLocaleString()),
        utilizationPercentage: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 38
          }
        }, userStats.usagePercentage)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "gear",
      color: "warning",
      onClick: onManageDataSources,
      "data-test-subj": "manage-data-sources-button-near-limit",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.manageDataSources",
      defaultMessage: "Manage data sources",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    })));
  }
  if (variant === 'compact') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.info.title",
        defaultMessage: "User limit information",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 11
        }
      }),
      color: "primary",
      iconType: "info",
      size: "s",
      "data-test-subj": "privileged-user-limit-info-callout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userLimit.info.description",
      defaultMessage: "Maximum supported number of privileged users allowed: {maxAllowed}",
      values: {
        maxAllowed: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 27
          }
        }, maxAllowed.toLocaleString())
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    })));
  }
  return null;
};
exports.UserLimitCallOut = UserLimitCallOut;
UserLimitCallOut.displayName = 'UserLimitCallOut';