"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCombinedRiskScoreKpi = void 0;
var _react = require("react");
var _types = require("../../../../common/entity_analytics/types");
var _search_strategy = require("../../../../common/search_strategy");
var _use_risk_score_kpi = require("../../api/hooks/use_risk_score_kpi");
var _use_global_filter_query = require("../../../common/hooks/use_global_filter_query");
var _use_global_time = require("../../../common/containers/use_global_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that aggregates risk score KPI data from all three entity types (user, host, service)
 * into a combined severity count for display in the threat hunting donut chart.
 */
const useCombinedRiskScoreKpi = skip => {
  var _combinedRiskKpi$seve;
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);

  // Memoize entity array to prevent re-creation on every render
  const entityTypes = (0, _react.useMemo)(() => [_types.EntityType.user, _types.EntityType.host, _types.EntityType.service], []);

  // Query all three entity types in a single call
  const combinedRiskKpi = (0, _use_risk_score_kpi.useRiskScoreKpi)({
    filterQuery,
    skip,
    riskEntity: entityTypes,
    timerange
  });
  const loading = combinedRiskKpi.loading;
  const error = combinedRiskKpi.error;
  const isModuleDisabled = combinedRiskKpi.isModuleDisabled;
  const refetch = () => {
    combinedRiskKpi.refetch();
  };
  return {
    severityCount: (_combinedRiskKpi$seve = combinedRiskKpi.severityCount) !== null && _combinedRiskKpi$seve !== void 0 ? _combinedRiskKpi$seve : _search_strategy.EMPTY_SEVERITY_COUNT,
    loading,
    error,
    isModuleDisabled,
    refetch
  };
};
exports.useCombinedRiskScoreKpi = useCombinedRiskScoreKpi;