"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CombinedRiskDonutChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _risk_score_donut_chart = require("../risk_score_donut_chart");
var _use_combined_risk_score_kpi = require("./use_combined_risk_score_kpi");
var _query_toggle = require("../../../common/containers/query_toggle");
var _manage_query = require("../../../common/components/page/manage_query");
var _use_global_time = require("../../../common/containers/use_global_time");
var _risk_level_breakdown_table = require("./risk_level_breakdown_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/threat_hunting/combined_risk_donut_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const COMBINED_RISK_SCORE_KPI_QUERY_ID = 'combinedRiskScoreKpiQuery';
const CombinedRiskDonutChart = () => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(COMBINED_RISK_SCORE_KPI_QUERY_ID);
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    severityCount,
    loading,
    refetch,
    isModuleDisabled
  } = (0, _use_combined_risk_score_kpi.useCombinedRiskScoreKpi)(!toggleStatus);
  (0, _manage_query.useQueryInspector)({
    queryId: COMBINED_RISK_SCORE_KPI_QUERY_ID,
    loading,
    refetch,
    setQuery,
    deleteQuery,
    inspect: undefined // Combined query doesn't have a single inspect object
  });
  if (isModuleDisabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.threatHunting.entityRiskLevels",
    defaultMessage: "Entity risk levels",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_level_breakdown_table.RiskLevelBreakdownTable, {
    severityCount: severityCount,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_score_donut_chart.RiskScoreDonutChart, {
    severityCount: severityCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  })))));
};
exports.CombinedRiskDonutChart = CombinedRiskDonutChart;