"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskScoreConfigurationWithDefaults = exports.DEFAULT_ENTITY_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ENTITY_TYPES = exports.DEFAULT_ENTITY_TYPES = ['host', 'user', 'service'];
const getRiskScoreConfigurationWithDefaults = riskEngineSettings => {
  var _riskEngineSettings$i, _riskEngineSettings$r, _riskEngineSettings$r2, _riskEngineSettings$r3, _riskEngineSettings$r4;
  return {
    ...riskEngineSettings,
    includeClosedAlerts: (_riskEngineSettings$i = riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : riskEngineSettings.includeClosedAlerts) !== null && _riskEngineSettings$i !== void 0 ? _riskEngineSettings$i : false,
    range: {
      start: (_riskEngineSettings$r = riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : (_riskEngineSettings$r2 = riskEngineSettings.range) === null || _riskEngineSettings$r2 === void 0 ? void 0 : _riskEngineSettings$r2.start) !== null && _riskEngineSettings$r !== void 0 ? _riskEngineSettings$r : 'now-30d',
      end: (_riskEngineSettings$r3 = riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : (_riskEngineSettings$r4 = riskEngineSettings.range) === null || _riskEngineSettings$r4 === void 0 ? void 0 : _riskEngineSettings$r4.end) !== null && _riskEngineSettings$r3 !== void 0 ? _riskEngineSettings$r3 : 'now'
    },
    enableResetToZero: (riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : riskEngineSettings.enableResetToZero) === undefined ? true : riskEngineSettings.enableResetToZero,
    filters: Array.isArray(riskEngineSettings === null || riskEngineSettings === void 0 ? void 0 : riskEngineSettings.filters) ? riskEngineSettings.filters : []
  };
};
exports.getRiskScoreConfigurationWithDefaults = getRiskScoreConfigurationWithDefaults;