"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertFiltersKqlBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../data_view_manager/constants");
var _containers = require("../../../sourcerer/containers");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("../../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_score_management/alert_filters_kql_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COMBOBOX_LABEL_MAPPING = {
  user: 'Users',
  host: 'Hosts',
  service: 'Services'
};
const DEFAULT_OPTIONS = [{
  label: COMBOBOX_LABEL_MAPPING.user,
  value: 'user'
}, {
  label: COMBOBOX_LABEL_MAPPING.host,
  value: 'host'
}, {
  label: COMBOBOX_LABEL_MAPPING.service,
  value: 'service'
}];
const ClickablePanelContainer = _styled.default.div`
  max-width: 300px;
  cursor: pointer;
`;
const TruncatedTextWrapper = _styled.default.div`
  max-width: ${({
  maxWidth
}) => maxWidth || '150px'};
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
const PopoverContentContainer = _styled.default.div`
  padding: ${({
  theme
}) => theme.euiTheme.size.xs};
  max-height: 280px;
  overflow: auto;
  word-break: break-word;
  white-space: pre-wrap;
`;
const ComboBoxContainer = _styled.default.div`
  min-width: 200px;
`;

// Custom component to render each filter chip with a combobox

const CustomFilterChip = ({
  filter,
  onRemove,
  onEntityTypesChange
}) => {
  const [selectedEntities, setSelectedEntities] = (0, _react.useState)(() => filter.entityTypes.map(et => ({
    label: COMBOBOX_LABEL_MAPPING[et],
    value: et
  })));
  const [isTooltipOpen, setIsTooltipOpen] = (0, _react.useState)(false);
  const onChange = (0, _react.useCallback)(options => {
    // Prevent deselecting all options - ensure at least one is selected
    if (options.length === 0) {
      return;
    }
    setSelectedEntities(options);
    const entityTypes = options.map(opt => opt.value).filter(et => et !== undefined);
    onEntityTypesChange(entityTypes);
  }, [onEntityTypesChange]);

  // Get the display string for the filter
  const filterDisplayString = filter.text;

  // Check if the query contains AND/OR operators (complex query)
  const hasOperators = /(\s+AND\s+|\s+OR\s+)/i.test(filterDisplayString);

  // For complex queries, display the entire query as-is
  // For simple queries, parse into field:value format
  const {
    fieldName,
    value
  } = hasOperators ? {
    fieldName: '',
    value: filterDisplayString
  } : (() => {
    const colonIndex = filterDisplayString.indexOf(':');
    if (colonIndex === -1) {
      return {
        fieldName: filterDisplayString,
        value: ''
      };
    }
    const parsedFieldName = filterDisplayString.substring(0, colonIndex).trim();
    const parsedValue = filterDisplayString.substring(colonIndex + 1).trim();
    return {
      fieldName: parsedFieldName,
      value: parsedValue
    };
  })();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: false,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isTooltipOpen,
    closePopover: () => setIsTooltipOpen(false),
    button: /*#__PURE__*/_react.default.createElement(ClickablePanelContainer, {
      onClick: () => setIsTooltipOpen(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      paddingSize: "xs",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      wrap: false,
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 17
      }
    }, fieldName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(TruncatedTextWrapper, {
      maxWidth: "150px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 27
      }
    }, `${fieldName}:\u00A0`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(TruncatedTextWrapper, {
      maxWidth: "150px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 27
      }
    }, value)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(TruncatedTextWrapper, {
      maxWidth: "250px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 25
      }
    }, value))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "cross",
      color: "text",
      onClick: onRemove,
      "aria-label": i18n.REMOVE_FILTER,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 21
      }
    }))))),
    panelStyle: {
      maxWidth: '500px',
      maxHeight: '300px'
    },
    anchorPosition: "upCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PopoverContentContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, filterDisplayString)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, i18n.APPLIED_TO_RISK_SCORES_OF)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ComboBoxContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: DEFAULT_OPTIONS,
    selectedOptions: selectedEntities,
    onChange: onChange,
    compressed: true,
    isClearable: false,
    singleSelection: false,
    placeholder: "Select entities",
    "aria-label": "Select entity types for filter application",
    fullWidth: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }))));
};
const AlertFiltersKqlBar = ({
  onQueryChange,
  onFiltersChange,
  filters = [],
  placeholder = i18n.ALERT_FILTERS_PLACEHOLDER,
  compressed = true,
  'data-test-subj': dataTestSubj = 'alertFiltersKqlBar'
}) => {
  const {
    sourcererDataView
  } = (0, _containers.useSourcererDataView)(_constants.PageScope.explore);
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    },
    data
  } = (0, _kibana.useKibana)().services;
  const [query, setQuery] = (0, _react.useState)({
    query: '',
    language: 'kuery'
  });
  const [dataView, setDataView] = (0, _react.useState)(null);
  const [validationError, setValidationError] = (0, _react.useState)();

  // Create DataView asynchronously to ensure fields are properly populated
  (0, _react.useEffect)(() => {
    let dv;
    const createDataView = async () => {
      if (sourcererDataView) {
        dv = await data.dataViews.create(sourcererDataView);
        setDataView(dv);
      }
    };
    createDataView();
    return () => {
      var _dv;
      if ((_dv = dv) !== null && _dv !== void 0 && _dv.id) {
        data.dataViews.clearInstanceCache(dv.id);
      }
    };
  }, [data.dataViews, sourcererDataView]);
  const handleQueryChange = (0, _react.useCallback)(payload => {
    if (payload.query) {
      setQuery(payload.query);

      // Validate KQL syntax in real-time
      const queryText = typeof payload.query.query === 'string' ? payload.query.query : String(payload.query.query);
      if (queryText.trim() && payload.query.language === 'kuery') {
        try {
          (0, _esQuery.fromKueryExpression)(queryText);
          setValidationError(undefined);
        } catch (error) {
          setValidationError(error instanceof Error ? error.message : 'Invalid KQL syntax');
        }
      } else {
        setValidationError(undefined);
      }
    }
  }, []);
  const handleQuerySubmit = (0, _react.useCallback)(payload => {
    if (payload.query) {
      const queryText = typeof payload.query.query === 'string' ? payload.query.query : String(payload.query.query);

      // Validate before submitting
      if (queryText.trim() && payload.query.language === 'kuery') {
        try {
          (0, _esQuery.fromKueryExpression)(queryText);
          setValidationError(undefined);

          // Add the query as a filter with default entity types (all)
          const newFilter = {
            id: Date.now().toString(),
            text: queryText,
            entityTypes: ['user', 'host', 'service']
          };
          const updatedFilters = [...filters, newFilter];
          onFiltersChange === null || onFiltersChange === void 0 ? void 0 : onFiltersChange(updatedFilters);
          onQueryChange === null || onQueryChange === void 0 ? void 0 : onQueryChange(payload.query);

          // Clear the query input
          setQuery({
            query: '',
            language: 'kuery'
          });
        } catch (error) {
          setValidationError(error instanceof Error ? error.message : 'Invalid KQL syntax');
        }
      }
    }
  }, [onQueryChange, onFiltersChange, filters]);
  const onRemoveFilter = (0, _react.useCallback)(filterToRemove => {
    const updatedFilters = filters.filter(f => f.id !== filterToRemove.id);
    onFiltersChange === null || onFiltersChange === void 0 ? void 0 : onFiltersChange(updatedFilters);
  }, [filters, onFiltersChange]);
  const onEntityTypesChange = (0, _react.useCallback)((filterId, entityTypes) => {
    const updatedFilters = filters.map(f => f.id === filterId ? {
      ...f,
      entityTypes
    } : f);
    onFiltersChange === null || onFiltersChange === void 0 ? void 0 : onFiltersChange(updatedFilters);
  }, [filters, onFiltersChange]);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.ALERT_FILTERS_LABEL,
    display: "rowCompressed",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "siem",
    showFilterBar: false,
    showQueryInput: true,
    showDatePicker: false,
    showQueryMenu: false,
    showSubmitButton: false,
    indexPatterns: [dataView],
    onQueryChange: handleQueryChange,
    onQuerySubmit: handleQuerySubmit,
    query: query,
    placeholder: placeholder,
    dataTestSubj: dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 9
    }
  }), validationError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    "data-test-subj": "alertFiltersKqlBarError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 13
    }
  }, validationError)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 9
    }
  }, filters.map(filter => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: filter.id,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CustomFilterChip, {
    filter: filter,
    onRemove: () => onRemoveFilter(filter),
    onEntityTypesChange: entityTypes => onEntityTypesChange(filter.id, entityTypes),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 15
    }
  }))))));
};
exports.AlertFiltersKqlBar = AlertFiltersKqlBar;