"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetLatestCSVPrivilegedUserUploadQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _esqlUtils = require("@kbn/esql-utils");
var _utils = require("../../../../../common/entity_analytics/privileged_user_monitoring/utils");
var _esql = require("../../../../common/utils/esql");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLatestCSVPrivilegedUserUploadQuery = namespace => {
  return `FROM ${(0, _utils.getPrivilegedMonitorUsersIndex)(namespace)}
    | WHERE labels.sources == "csv"
    | STATS latest_timestamp = MAX(@timestamp)`;
};
const GET_LATEST_CSV_UPLOAD_QUERY_ID = 'getPrivilegedUserMonitoringLatestCsvQuery';
const useGetLatestCSVPrivilegedUserUploadQuery = namespace => {
  var _data$find;
  const search = (0, _kibana.useKibana)().services.data.search.search;
  const {
    isLoading,
    data,
    isError,
    refetch
  } = (0, _reactQuery.useQuery)([GET_LATEST_CSV_UPLOAD_QUERY_ID], async ({
    signal
  }) => {
    var _await$getESQLResults;
    return (0, _esql.esqlResponseToRecords)((_await$getESQLResults = await (0, _esqlUtils.getESQLResults)({
      esqlQuery: getLatestCSVPrivilegedUserUploadQuery(namespace),
      search,
      signal
    })) === null || _await$getESQLResults === void 0 ? void 0 : _await$getESQLResults.response);
  });
  const latestTimestamp = data ? (_data$find = data.find(Boolean)) === null || _data$find === void 0 ? void 0 : _data$find.latest_timestamp : undefined;
  return {
    latestTimestamp,
    isLoading,
    isError,
    refetch
  };
};
exports.useGetLatestCSVPrivilegedUserUploadQuery = useGetLatestCSVPrivilegedUserUploadQuery;