"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createKeyInsightsPanelLensAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createKeyInsightsPanelLensAttributes = ({
  title,
  label,
  esqlQuery,
  dataViewId,
  filterQuery
}) => {
  return {
    title,
    description: '',
    visualizationType: 'lnsMetric',
    state: {
      visualization: {
        layerId: 'layer1',
        layerType: 'data',
        metricAccessor: 'count'
      },
      query: {
        query: esqlQuery,
        language: 'esql'
      },
      filters: [{
        query: filterQuery,
        meta: {}
      }],
      datasourceStates: {
        textBased: {
          layers: {
            layer1: {
              columns: [{
                columnId: 'count',
                fieldName: 'count',
                label,
                customLabel: true,
                params: {
                  format: {
                    id: 'number',
                    params: {
                      decimals: 0,
                      compact: false
                    }
                  }
                }
              }],
              query: {
                esql: esqlQuery
              }
            }
          }
        }
      },
      adHocDataViews: {
        [dataViewId]: {
          id: dataViewId
        }
      }
    },
    references: []
  };
};
exports.createKeyInsightsPanelLensAttributes = createKeyInsightsPanelLensAttributes;