"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAuthenticationsEsqlCount = void 0;
var _Either = require("fp-ts/Either");
var _authentications_esql_query = require("../../../queries/authentications_esql_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAuthenticationsEsqlCount = (namespace, sourcerDataView) => {
  var _sourcerDataView$titl, _sourcerDataView$fiel;
  const indexPattern = (_sourcerDataView$titl = sourcerDataView === null || sourcerDataView === void 0 ? void 0 : sourcerDataView.title) !== null && _sourcerDataView$titl !== void 0 ? _sourcerDataView$titl : '';
  const fields = (_sourcerDataView$fiel = sourcerDataView === null || sourcerDataView === void 0 ? void 0 : sourcerDataView.fields) !== null && _sourcerDataView$fiel !== void 0 ? _sourcerDataView$fiel : {};
  const esqlSource = (0, _authentications_esql_query.getAuthenticationsEsqlSource)(namespace, indexPattern, fields);
  return (0, _Either.map)(src => `${src} | STATS count = COUNT(*)`)(esqlSource);
};
exports.getAuthenticationsEsqlCount = getAuthenticationsEsqlCount;