"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsTriggeredEsqlCount = void 0;
var _helpers = require("../../../queries/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsTriggeredEsqlCount = (namespace, alertsIndexName) => {
  if (!alertsIndexName) return '';
  return `FROM ${alertsIndexName}
    ${(0, _helpers.getPrivilegeMonitrUsersJoinNoTimestamp)(namespace)}
    | STATS count = COUNT(*)`;
};
exports.getAlertsTriggeredEsqlCount = getAlertsTriggeredEsqlCount;