"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskInputsTab = exports.RISK_INPUTS_TAB_QUERY_ID = exports.EXPAND_ALERT_TEST_ID = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _alert_preview_button = require("../../../../../flyout/shared/components/alert_preview_button");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _manage_query = require("../../../../../common/components/page/manage_query");
var _common = require("../../../../common");
var _use_risk_contributing_alerts = require("../../../../hooks/use_risk_contributing_alerts");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _use_risk_score = require("../../../../api/hooks/use_risk_score");
var _search_strategy = require("../../../../../../common/search_strategy");
var _asset_criticality = require("../../../asset_criticality");
var _utility_bar = require("../../components/utility_bar");
var _action_column = require("../../components/action_column");
var _ask_ai_assistant = require("./ask_ai_assistant");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/tabs/risk_inputs/risk_inputs_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const EXPAND_ALERT_TEST_ID = exports.EXPAND_ALERT_TEST_ID = 'risk-input-alert-preview-button';
const RISK_INPUTS_TAB_QUERY_ID = exports.RISK_INPUTS_TAB_QUERY_ID = 'RiskInputsTabQuery';
const RiskInputsTab = ({
  entityType,
  entityName,
  scopeId
}) => {
  const {
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const nameFilterQuery = (0, _react.useMemo)(() => {
    return (0, _search_strategy.buildEntityNameFilter)(entityType, [entityName]);
  }, [entityName, entityType]);
  const {
    data: riskScoreData,
    error: riskScoreError,
    loading: loadingRiskScore,
    inspect: inspectRiskScore,
    refetch
  } = (0, _use_risk_score.useRiskScore)({
    riskEntity: entityType,
    filterQuery: nameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION,
    skip: nameFilterQuery === undefined
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectRiskScore,
    loading: loadingRiskScore,
    queryId: RISK_INPUTS_TAB_QUERY_ID,
    refetch,
    setQuery
  });
  const riskScore = riskScoreData && riskScoreData.length > 0 ? riskScoreData[0] : undefined;
  const alerts = (0, _use_risk_contributing_alerts.useRiskContributingAlerts)({
    riskScore,
    entityType
  });
  const euiTableSelectionProps = (0, _react.useMemo)(() => ({
    initialSelected: [],
    selectable: () => true,
    onSelectionChange: setSelectedItems
  }), []);
  const inputColumns = (0, _react.useMemo)(() => [{
    render: data => /*#__PURE__*/_react.default.createElement(_alert_preview_button.AlertPreviewButton, {
      id: data._id,
      indexName: data.input.index,
      scopeId: scopeId,
      "data-test-subj": EXPAND_ALERT_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }),
    width: '5%'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actionsColumn",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }),
    width: '80px',
    render: data => /*#__PURE__*/_react.default.createElement(_action_column.ActionColumn, {
      input: data,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 39
      }
    })
  }, {
    field: 'input.timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.dateColumn",
      defaultMessage: "Date",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    width: '30%',
    render: timestamp => /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(timestamp),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 40
      }
    })
  }, {
    field: 'alert',
    'data-test-subj': 'risk-input-table-description-cell',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.riskInputColumn",
      defaultMessage: "Rule name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }),
    truncateText: true,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: alert => (0, _fp.get)(_ruleDataUtils.ALERT_RULE_NAME, alert)
  }, {
    field: 'input.contribution_score',
    'data-test-subj': 'risk-input-table-contribution-cell',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contributionColumn",
      defaultMessage: "Contribution",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    align: 'right',
    render: formatContribution
  }], [scopeId]);
  if (riskScoreError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.errorTitle",
        defaultMessage: "Something went wrong",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 11
        }
      }),
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.errorBody",
      defaultMessage: "Error while fetching risk inputs. Please try again later.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 11
      }
    })));
  }
  const riskInputsAlertSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "risk-input-alert-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.alertsTitle",
    defaultMessage: "Alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_utility_bar.RiskInputsUtilityBar, {
    riskInputs: selectedItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    loading: loadingRiskScore || alerts.loading,
    items: alerts.data || [],
    columns: inputColumns,
    sorting: true,
    selection: euiTableSelectionProps,
    itemId: "_id",
    tableCaption: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskInputs.alertsTableCaption', {
      defaultMessage: 'Alerts contributing to the risk score'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ExtraAlertsMessage, {
    riskScore: riskScore,
    alerts: alerts,
    entityType: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ContextsSection, {
    loading: loadingRiskScore,
    riskScore: riskScore,
    entityType: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), riskInputsAlertSection, /*#__PURE__*/_react.default.createElement(_ask_ai_assistant.AskAiAssistant, {
    entityType: entityType,
    entityName: entityName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }));
};
exports.RiskInputsTab = RiskInputsTab;
RiskInputsTab.displayName = 'RiskInputsTab';
const ContextsSection = ({
  riskScore,
  loading,
  entityType
}) => {
  const isPrivmonEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('enableRiskScorePrivmonModifier');
  const contributions = (0, _react.useMemo)(() => {
    var _riskScore$entityType, _riskScore$entityType2, _criticality$metadata, _privmon$metadata, _privmon$contribution;
    if (!riskScore) {
      return undefined;
    }
    const privmon = (_riskScore$entityType = riskScore[entityType].risk.modifiers) === null || _riskScore$entityType === void 0 ? void 0 : _riskScore$entityType.find(mod => mod.type === 'watchlist' && mod.subtype === 'privmon');
    const criticality = (_riskScore$entityType2 = riskScore[entityType].risk.modifiers) === null || _riskScore$entityType2 === void 0 ? void 0 : _riskScore$entityType2.find(mod => mod.type === 'asset_criticality');
    return {
      criticality: {
        level: isPrivmonEnabled ? criticality === null || criticality === void 0 ? void 0 : (_criticality$metadata = criticality.metadata) === null || _criticality$metadata === void 0 ? void 0 : _criticality$metadata.criticality_level : riskScore[entityType].risk.criticality_level,
        contribution: isPrivmonEnabled ? criticality === null || criticality === void 0 ? void 0 : criticality.contribution : riskScore[entityType].risk.category_2_score
      },
      privmon: {
        isPrivileged: privmon ? (_privmon$metadata = privmon.metadata) === null || _privmon$metadata === void 0 ? void 0 : _privmon$metadata.is_privileged_user : false,
        contribution: (_privmon$contribution = privmon === null || privmon === void 0 ? void 0 : privmon.contribution) !== null && _privmon$contribution !== void 0 ? _privmon$contribution : 0
      }
    };
  }, [entityType, riskScore, isPrivmonEnabled]);
  if (loading || contributions === undefined) {
    return null;
  }
  const {
    criticality,
    privmon
  } = contributions;
  const items = [{
    field: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.assetCriticalityField",
      defaultMessage: "Asset Criticality Level",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 9
      }
    }),
    value: /*#__PURE__*/_react.default.createElement(_asset_criticality.AssetCriticalityBadge, {
      criticalityLevel: criticality.level,
      dataTestSubj: "risk-inputs-asset-criticality-badge",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 9
      }
    }),
    contribution: formatContribution(criticality.contribution || 0)
  }];
  if (isPrivmonEnabled) {
    items.push({
      field: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.privmonField",
        defaultMessage: "Privileged user",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 9
        }
      }),
      value: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.privmonValue",
        defaultMessage: "{value}",
        values: {
          value: privmon.isPrivileged ? 'Yes' : 'No'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 312,
          columnNumber: 9
        }
      }),
      contribution: formatContribution(privmon.contribution || 0)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "risk-input-contexts-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contextsTitle",
    defaultMessage: "Contexts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    loading: loading,
    "data-test-subj": "risk-input-contexts-table",
    columns: contextColumns,
    items: items,
    tableCaption: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskInputs.contextsTableCaption', {
      defaultMessage: 'Contextual contributions to the risk score'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 7
    }
  }));
};
const contextColumns = [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.fieldColumn",
    defaultMessage: "Field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 7
    }
  }),
  width: '30%',
  render: field => field
}, {
  field: 'value',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.valueColumn",
    defaultMessage: "Value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 7
    }
  }),
  width: '30%',
  render: val => val
}, {
  field: 'contribution',
  width: '30%',
  align: 'right',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contributionColumn",
    defaultMessage: "Contribution",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 7
    }
  }),
  render: score => score
}];
const ExtraAlertsMessage = ({
  riskScore,
  alerts,
  entityType
}) => {
  var _alerts$data, _alerts$data2;
  const totals = !riskScore ? {
    count: 0,
    score: 0
  } : {
    count: riskScore[entityType].risk.category_1_count,
    score: riskScore[entityType].risk.category_1_score
  };
  const displayed = {
    count: ((_alerts$data = alerts.data) === null || _alerts$data === void 0 ? void 0 : _alerts$data.length) || 0,
    score: ((_alerts$data2 = alerts.data) === null || _alerts$data2 === void 0 ? void 0 : _alerts$data2.reduce((sum, {
      input
    }) => sum + (input.contribution_score || 0), 0)) || 0
  };
  if (displayed.count >= totals.count) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "risk-input-extra-alerts-message",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.extraAlertsMessage",
      defaultMessage: "{count} more alerts contributed {score} to the calculated risk score",
      values: {
        count: totals.count - displayed.count,
        score: formatContribution(totals.score - displayed.score)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 9
      }
    }),
    iconType: "annotation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 5
    }
  });
};
const formatContribution = value => {
  const fixedValue = (0, _common.formatRiskScore)(value);

  // prevent +0.00 for values like 0.0001
  if (fixedValue === '0.00') {
    return fixedValue;
  }
  if (value > 0) {
    return `+${fixedValue}`;
  }
  return fixedValue;
};