"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AskAiAssistant = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _get_anonymized_values = require("@kbn/elastic-assistant-common/impl/data_anonymization/get_anonymized_values");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_agent_builder_availability = require("../../../../../agent_builder/hooks/use_agent_builder_availability");
var _types = require("../../../../../../common/entity_analytics/types");
var _new_agent_builder_attachment = require("../../../../../agent_builder/components/new_agent_builder_attachment");
var _use_agent_builder_attachment = require("../../../../../agent_builder/hooks/use_agent_builder_attachment");
var _use_ask_ai_assistant = require("./use_ask_ai_assistant");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/tabs/risk_inputs/ask_ai_assistant.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CURRENT_REPLACEMENTS = {};
const AskAiAssistant = ({
  entityType,
  entityName
}) => {
  var _anonymizedValues$;
  const entityField = _types.EntityTypeToIdentifierField[entityType];
  const {
    data: anonymizationFields
  } = (0, _elasticAssistant.useFetchAnonymizationFields)();
  const isAssistantToolDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('riskScoreAssistantToolDisabled');
  const {
    isAgentBuilderEnabled,
    isAgentChatExperienceEnabled
  } = (0, _use_agent_builder_availability.useAgentBuilderAvailability)();
  const {
    anonymizedValues,
    replacements
  } = (0, _react.useMemo)(() => {
    if (!anonymizationFields.data) {
      return {
        anonymizedValues: [],
        replacements: CURRENT_REPLACEMENTS
      };
    }
    return (0, _get_anonymized_values.getAnonymizedValues)({
      anonymizationFields: anonymizationFields.data,
      currentReplacements: CURRENT_REPLACEMENTS,
      field: entityField,
      getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
      rawData: {
        [entityField]: [entityName]
      }
    });
  }, [anonymizationFields, entityField, entityName]);
  const anonymizedEntityName = (_anonymizedValues$ = anonymizedValues[0]) !== null && _anonymizedValues$ !== void 0 ? _anonymizedValues$ : entityName;
  const getPromptContext = (0, _react.useCallback)(async () => `### The following entity is under investigation:\nType: ${entityType}\nIdentifier: ${`\`${anonymizedEntityName}\``}`, [anonymizedEntityName, entityType]);
  const {
    showAssistantOverlay,
    disabled: aiAssistantDisable
  } = (0, _use_ask_ai_assistant.useAskAiAssistant)({
    title: `Explain ${entityType} '${entityName}' Risk Score`,
    description: `Entity: ${entityName}`,
    suggestedPrompt: `Explain how inputs contributed to the risk score, including any risk modifiers such as asset criticality or privileged user monitoring status. Additionally, outline the recommended next steps for investigating or mitigating the risk if the entity is deemed risky.\nTo answer risk score questions, fetch the risk score information and take into consideration both the risk score inputs and any modifiers that adjusted the final score.`,
    getPromptContext,
    replacements
  });
  const entityAttachment = (0, _react.useMemo)(() => ({
    attachmentType: _constants.SecurityAgentBuilderAttachments.entity,
    attachmentData: {
      identifierType: entityType,
      identifier: entityName,
      attachmentLabel: `${entityType}: ${entityName}`
    },
    attachmentPrompt: `Explain how inputs contributed to the risk score, including any risk modifiers such as asset criticality or privileged user monitoring status. Additionally, outline the recommended next steps for investigating or mitigating the risk if the entity is deemed risky.\nTo answer risk score questions, fetch the risk score information and take into consideration both the risk score inputs and any modifiers that adjusted the final score.`
  }), [entityName, entityType]);
  const {
    openAgentBuilderFlyout
  } = (0, _use_agent_builder_attachment.useAgentBuilderAttachment)(entityAttachment);
  if ((aiAssistantDisable || isAssistantToolDisabled) && !isAgentBuilderEnabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, isAgentChatExperienceEnabled ? /*#__PURE__*/_react.default.createElement(_new_agent_builder_attachment.NewAgentBuilderAttachment, {
    onClick: openAgentBuilderFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "explain-with-ai-button",
    iconType: _aiAssistantIcon.AssistantIcon,
    iconSide: "right",
    onClick: () => {
      showAssistantOverlay();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.askAiAssistant",
    defaultMessage: "Ask AI Assistant",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  })))));
};
exports.AskAiAssistant = AskAiAssistant;
AskAiAssistant.displayName = 'ExplainWithAiAssistant';