"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityHighlightsSettings = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _lodash = require("lodash");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react2 = require("@emotion/react");
var _fp = require("lodash/fp");
var _use_agent_builder_availability = require("../../../../agent_builder/hooks/use_agent_builder_availability");
var _prompts = require("../../../../agent_builder/components/prompts");
var _new_agent_builder_attachment = require("../../../../agent_builder/components/new_agent_builder_attachment");
var _use_agent_builder_attachment = require("../../../../agent_builder/hooks/use_agent_builder_attachment");
var _use_ask_ai_assistant = require("../tabs/risk_inputs/use_ask_ai_assistant");
var _helpers = require("../utils/helpers");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/components/entity_highlights_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityHighlightsSettings = ({
  showAnonymizedValues,
  onChangeShowAnonymizedValues,
  setConnectorId,
  connectorId,
  closePopover,
  openPopover,
  isLoading,
  isPopoverOpen,
  entityType,
  entityIdentifier,
  isAssistantVisible,
  assistantResult
}) => {
  const selectedConversationHasAnonymizedValues = (0, _react.useMemo)(() => !(0, _fp.isEmpty)(assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements), [assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements]);
  const anonymizedEntityIdentifier = (0, _react.useMemo)(() => assistantResult !== null && assistantResult !== void 0 && assistantResult.replacements ? (0, _helpers.getAnonymizedEntityIdentifier)(entityIdentifier, assistantResult.replacements) : entityIdentifier, [entityIdentifier, assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements]);
  const getPromptContext = (0, _react.useCallback)(async () => `### The following entity is under investigation:\nType: ${entityType}\nIdentifier: ${`\`${anonymizedEntityIdentifier}\``}\n#### Context:\n\`\`\`json\n${assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.summaryAsText}`, [anonymizedEntityIdentifier, assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.summaryAsText, entityType]);
  const {
    showAssistantOverlay
  } = (0, _use_ask_ai_assistant.useAskAiAssistant)({
    title: `Investigating ${entityType} '${entityIdentifier}'`,
    description: `Entity: ${entityIdentifier}`,
    suggestedPrompt: `Investigate the entity and suggest next steps.`,
    getPromptContext,
    replacements: assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.replacements
  });
  const {
    isAgentBuilderEnabled
  } = (0, _use_agent_builder_availability.useAgentBuilderAvailability)();
  const entityAttachment = (0, _react.useMemo)(() => ({
    attachmentType: _constants.SecurityAgentBuilderAttachments.entity,
    attachmentData: {
      identifierType: entityType,
      identifier: entityIdentifier,
      attachmentLabel: `${entityType}: ${entityIdentifier}`
    },
    attachmentPrompt: _prompts.ENTITY_PROMPT
  }), [entityIdentifier, entityType]);
  const {
    openAgentBuilderFlyout
  } = (0, _use_agent_builder_attachment.useAgentBuilderAttachment)(entityAttachment);
  const onAgentBuildAttachmentClick = (0, _react.useCallback)(() => {
    openAgentBuilderFlyout();
    closePopover();
  }, [closePopover, openAgentBuilderFlyout]);
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "none",
    key: 'entity-highlights-settings-menu',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.anonymizeValuesAriaLabel', {
      defaultMessage: 'Show anonymized values'
    }),
    key: "anonymize-values",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.showAnonymizedValues', {
      defaultMessage: 'Show anonymized values'
    }),
    checked: showAnonymizedValues,
    onChange: onChangeShowAnonymizedValues,
    compressed: true,
    disabled: !selectedConversationHasAnonymizedValues,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  })))), isAgentBuilderEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.askAiAssistantAriaLabel', {
      defaultMessage: 'Ask AI Assistant'
    }),
    key: 'ask-ai-assistant',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_new_agent_builder_attachment.NewAgentBuilderAttachment, {
    onClick: onAgentBuildAttachmentClick,
    size: "s",
    disabled: isLoading || !assistantResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  })) : isAssistantVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.askAiAssistantAriaLabel', {
      defaultMessage: 'Ask AI Assistant'
    }),
    key: 'ask-ai-assistant',
    onClick: () => {
      showAssistantOverlay();
      closePopover();
    },
    icon: /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 21
      }
    }),
    disabled: isLoading || !assistantResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.askAiAssistant",
    defaultMessage: "Ask AI Assistant",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.connectorSelectorAriaLabel', {
      defaultMessage: 'Connector selector'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    onConnectorSelected: _lodash.noop,
    onConnectorIdSelected: setConnectorId,
    selectedConnectorId: connectorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  })))], [showAnonymizedValues, onChangeShowAnonymizedValues, selectedConversationHasAnonymizedValues, onAgentBuildAttachmentClick, isAssistantVisible, setConnectorId, connectorId, showAssistantOverlay, closePopover, isAgentBuilderEnabled, isLoading, assistantResult]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.openMenuAriaLabel', {
        defaultMessage: 'Entity highlights settings menu'
      }),
      iconType: "boxesVertical",
      onClick: openPopover,
      disabled: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "leftUp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    css: (0, _react2.css)`
          width: 280px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }));
};
exports.EntityHighlightsSettings = EntityHighlightsSettings;