"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityHighlightsResult = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _entity_highlights_gradients = require("./entity_highlights_gradients");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/components/entity_highlights_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityHighlightsResult = ({
  assistantResult,
  showAnonymizedValues,
  generatedAt,
  onRefresh
}) => {
  const {
    gradientPanelStyle
  } = (0, _entity_highlights_gradients.useGradientStyles)();
  const anonymizedResult = useAnonymizedResponse(assistantResult, showAnonymizedValues);
  const textToCopy = (0, _react.useMemo)(() => formatTextToCopy(anonymizedResult), [anonymizedResult]);
  if (!anonymizedResult) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: gradientPanelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, anonymizedResult.highlights.length > 0 ? anonymizedResult.highlights.map((highlight, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }, highlight.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, highlight.text), index < anonymizedResult.highlights.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 64
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.emptyState",
    defaultMessage: "There's not enough data to create an AI summary.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  })), anonymizedResult.recommendedActions && anonymizedResult.recommendedActions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documentation",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.recommendedActions",
    defaultMessage: "Recommended actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, anonymizedResult.recommendedActions.map(action => `- ${action}`).join('\n'))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, generatedAt && anonymizedResult.highlights.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.generatedTimestamp",
    defaultMessage: "Generated by AI on {timestamp}",
    values: {
      timestamp: (0, _moment.default)(generatedAt).format('MMM DD, YYYY [at] HH:mm')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "refresh",
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.refreshAriaLabel', {
      defaultMessage: 'Regenerate summary'
    }),
    onClick: onRefresh,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  })), textToCopy && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: textToCopy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "copy",
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.highlights.copyAriaLabel', {
      defaultMessage: 'Copy summary'
    }),
    onClick: copy,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 23
    }
  }))))))));
};
exports.EntityHighlightsResult = EntityHighlightsResult;
const useAnonymizedResponse = (assistantResult, showAnonymizedValues) => {
  return (0, _react.useMemo)(() => {
    if (!(assistantResult !== null && assistantResult !== void 0 && assistantResult.response)) return null;
    const response = assistantResult.response;
    if (!showAnonymizedValues) {
      return {
        highlights: response.highlights.map(highlight => ({
          title: highlight.title,
          text: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
            messageContent: highlight.text,
            replacements: assistantResult.replacements
          })
        })),
        recommendedActions: response.recommendedActions ? response.recommendedActions.map(action => (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
          messageContent: action,
          replacements: assistantResult.replacements
        })) : null
      };
    }
    return response;
  }, [assistantResult, showAnonymizedValues]);
};
const formatTextToCopy = response => {
  if (!response) return '';
  return response.highlights.map(highlight => `- ${highlight.title}\n${highlight.text}\n`).join('\n').concat(response.recommendedActions ? `\nRecommended actions:\n${response.recommendedActions.map(action => `- ${action} \n`).join('\n')}` : '');
};