"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGradientStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireWildcard(require("react"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/components/entity_highlights_gradients.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove Gradient constants when EUI supports AI gradients (borders, icons, etc.)
// see https://github.com/elastic/kibana-team/issues/2398

// Shared gradient variables
const gradientStartPercent = 2.98;
const gradientEndPercent = 66.24;
const panelBackgroundGradientAngle = 98;
const panelBorderAndButtonGradientAngle = 131;
const lightModeColors = {
  panelBackgroundGradient: `linear-gradient(${panelBackgroundGradientAngle}deg, rgba(217, 232, 255, 0.3) ${gradientStartPercent}%, rgba(236, 226, 254, 0.3) ${gradientEndPercent}%)`,
  panelBorderGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, rgba(23, 80, 186, 0.35) ${gradientStartPercent}%, rgba(115, 29, 207, 0.35) ${gradientEndPercent}%)`,
  buttonGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, #0b64dd ${gradientStartPercent}%, #731dcf ${gradientEndPercent}%)`,
  iconGradientStartColor: '#0B64DD',
  iconGradientEndColor: '#731DCF'
};
const darkModeColors = {
  panelBackgroundGradient: `linear-gradient(${panelBackgroundGradientAngle}deg, rgba(15, 40, 90, 0.15) ${gradientStartPercent}%, rgba(40, 20, 60, 0.15) ${gradientEndPercent}%)`,
  panelBorderGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, rgba(60, 120, 220, 0.4) ${gradientStartPercent}%, rgba(140, 60, 200, 0.4) ${gradientEndPercent}%)`,
  buttonGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, #1E7FE8 ${gradientStartPercent}%, #8B2DD6 ${gradientEndPercent}%)`,
  iconGradientStartColor: '#1E7FE8',
  iconGradientEndColor: '#8B2DD6'
};
const useGradientStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return (0, _react2.useMemo)(() => {
    const colors = isDarkMode ? darkModeColors : lightModeColors;
    return {
      gradientSVG: /*#__PURE__*/_react2.default.createElement("svg", {
        width: "0",
        height: "0",
        style: {
          position: 'absolute'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement("defs", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement("linearGradient", {
        id: "sparkles-gradient",
        x1: "0%",
        y1: "0%",
        x2: "100%",
        y2: "100%",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement("stop", {
        offset: `${gradientStartPercent}%`,
        stopColor: colors.iconGradientStartColor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react2.default.createElement("stop", {
        offset: `${gradientEndPercent}%`,
        stopColor: colors.iconGradientEndColor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 15
        }
      })))),
      gradientPanelStyle: (0, _react.css)`
        position: relative;
        background: ${colors.panelBackgroundGradient};
        border-radius: ${euiTheme.border.radius.medium};
        padding: ${euiTheme.size.m};
        &::before {
          content: '';
          position: absolute;
          inset: 0;
          padding: 1px;
          background: ${colors.panelBorderGradient};
          border-radius: ${euiTheme.border.radius.medium};
          mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
          mask-composite: exclude;
          -webkit-mask-composite: xor;
          pointer-events: none;
        }
      `,
      buttonGradientStyle: (0, _react.css)`
        background: ${colors.buttonGradient} !important;
        border-radius: 4px;
        color: #fff !important;
        &:hover:not(:disabled) {
          background: ${colors.buttonGradient} !important;
          color: #fff !important;
        }
        &:focus:not(:disabled) {
          background: ${colors.buttonGradient} !important;
          color: #fff !important;
        }
        &:disabled {
          opacity: 0.5;
        }
      `,
      iconGradientStyle: (0, _react.css)`
        & * {
          fill: url(#sparkles-gradient) !important;
        }
      `
    };
  }, [euiTheme, isDarkMode]);
};
exports.useGradientStyles = useGradientStyles;