"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsAnomalies = exports.ENTITY_ANALYTICS_ANOMALIES_PANEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ml-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _header_section = require("../../../common/components/header_section");
var _query_toggle = require("../../../common/containers/query_toggle");
var _last_updated_at = require("../../../common/components/last_updated_at");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_anomalies_search = require("../../../common/components/ml/anomaly/use_anomalies_search");
var _columns = require("./columns");
var _manage_query = require("../../../common/components/page/manage_query");
var _use_global_time = require("../../../common/containers/use_global_time");
var _links = require("../../../common/components/links");
var _model = require("../../../explore/hosts/store/model");
var _redirect_to_hosts = require("../../../common/components/link_to/redirect_to_hosts");
var _types = require("../../../app/types");
var _redirect_to_users = require("../../../common/components/link_to/redirect_to_users");
var _model2 = require("../../../explore/users/store/model");
var _kibana = require("../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_anomalies/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TABLE_QUERY_ID = 'entityAnalyticsDashboardAnomaliesTable';
const TABLE_SORTING = {
  sort: {
    field: 'count',
    direction: 'desc'
  }
};
const ENTITY_ANALYTICS_ANOMALIES_PANEL = exports.ENTITY_ANALYTICS_ANOMALIES_PANEL = 'entity_analytics_anomalies';
const EntityAnalyticsAnomalies = () => {
  const [recentlyEnabledJobIds, setRecentlyEnabledJobIds] = (0, _react.useState)([]);
  const {
    services: {
      ml,
      http,
      docLinks
    }
  } = (0, _kibana.useKibana)();
  const jobsUrl = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: _public.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE
  });
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(TABLE_QUERY_ID);
  const {
    deleteQuery,
    setQuery,
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    isLoading: isSearchLoading,
    data,
    refetch
  } = (0, _use_anomalies_search.useAggregatedAnomaliesByJob)({
    skip: !toggleStatus,
    from,
    to
  });
  const onJobEnabled = (0, _react.useCallback)(async job => {
    setRecentlyEnabledJobIds(current => [...current, job.id]);
  }, []);
  const columns = (0, _columns.useAnomaliesColumns)(isSearchLoading, onJobEnabled, recentlyEnabledJobIds);
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  (0, _react.useEffect)(() => {
    setUpdatedAt(Date.now());
  }, [isSearchLoading]); // Update the time when data loads

  (0, _manage_query.useQueryInspector)({
    refetch,
    queryId: TABLE_QUERY_ID,
    loading: isSearchLoading,
    setQuery,
    deleteQuery
  });
  const [goToHostsAnomaliesTab, hostsAnomaliesTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = getSecuritySolutionLinkProps({
      deepLinkId: _types.SecurityPageName.hosts,
      path: (0, _redirect_to_hosts.getTabsOnHostsUrl)(_model.HostsTableType.anomalies)
    });
    return [onClick, href];
  }, [getSecuritySolutionLinkProps]);
  const [goToUsersAnomaliesTab, usersAnomaliesTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = getSecuritySolutionLinkProps({
      deepLinkId: _types.SecurityPageName.users,
      path: (0, _redirect_to_users.getTabsOnUsersUrl)(_model2.UsersTableType.anomalies)
    });
    return [onClick, href];
  }, [getSecuritySolutionLinkProps]);
  const installedJobsIds = (0, _react.useMemo)(() => data.filter(({
    job
  }) => !!job && job.isInstalled).map(({
    job
  }) => {
    var _job$id;
    return (_job$id = job === null || job === void 0 ? void 0 : job.id) !== null && _job$id !== void 0 ? _job$id : '';
  }).concat(recentlyEnabledJobIds), [data, recentlyEnabledJobIds]);
  const incompatibleJobCount = (0, _react.useMemo)(() => data.filter(({
    job
  }) => job && !job.isCompatible).length, [data]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": ENTITY_ANALYTICS_ANOMALIES_PANEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.ANOMALIES_TITLE,
    titleSize: "s",
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      isUpdating: isSearchLoading,
      updatedAt: updatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 19
      }
    }),
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    tooltip: i18n.ANOMALIES_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    "data-test-subj": "anomalies_table_hosts_link",
    onClick: goToHostsAnomaliesTab,
    href: hostsAnomaliesTabUrl,
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, i18n.VIEW_ALL_HOSTS_ANOMALIES)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    "data-test-subj": "anomalies_table_users_link",
    onClick: goToUsersAnomaliesTab,
    href: usersAnomaliesTabUrl,
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, i18n.VIEW_ALL_USERS_ANOMALIES)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    "data-test-subj": "anomalies_table_all",
    href: jobsUrl,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, i18n.VIEW_ALL_ANOMALIES)))), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, incompatibleJobCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: i18n.MODULE_NOT_COMPATIBLE_TITLE(incompatibleJobCount),
    "data-test-subj": "incompatible_jobs_warnings",
    color: "warning",
    iconType: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "We could not find any data, see {mlDocs} for more information on Machine Learning job requirements.",
    id: "xpack.securitySolution.components.mlPopup.moduleNotCompatibleDescription",
    values: {
      mlDocs: /*#__PURE__*/_react.default.createElement("a", {
        href: `${docLinks.links.siem.ml}`,
        rel: "noopener noreferrer",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 25
        }
      }, i18n.ANOMALY_DETECTION_DOCS)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_public.MLJobsAwaitingNodeWarning, {
    jobIds: installedJobsIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    responsiveBreakpoint: false,
    items: data,
    columns: columns,
    pagination: {
      showPerPageOptions: true
    },
    loading: isSearchLoading,
    id: TABLE_QUERY_ID,
    sorting: TABLE_SORTING,
    tableCaption: i18n.ANOMALIES_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  })));
};
exports.EntityAnalyticsAnomalies = EntityAnalyticsAnomalies;