"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskEngineStatus = exports.useRiskEngineCountdownTime = exports.useInvalidateRiskEngineStatusQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_RISK_ENGINE_STATUS = ['GET', 'FETCH_RISK_ENGINE_STATUS'];
const useInvalidateRiskEngineStatusQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(FETCH_RISK_ENGINE_STATUS, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateRiskEngineStatusQuery = useInvalidateRiskEngineStatusQuery;
const useRiskEngineCountdownTime = riskEngineStatus => {
  const {
    status,
    runAt
  } = (riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_task_status) || {};
  const isRunning = status === 'running' || !!runAt && new Date(runAt) < new Date();
  return isRunning ? _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.riskEngine.nowRunningMessage', {
    defaultMessage: 'Now running'
  }) : (0, _moment.default)(runAt).fromNow(true);
};
exports.useRiskEngineCountdownTime = useRiskEngineCountdownTime;
const useRiskEngineStatus = (queryOptions = {}) => {
  const {
    fetchRiskEngineStatus
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useQuery)(FETCH_RISK_ENGINE_STATUS, async ({
    signal
  }) => fetchRiskEngineStatus({
    signal
  }), queryOptions);
};
exports.useRiskEngineStatus = useRiskEngineStatus;